/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.network.jms;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import org.activemq.Service;
import org.activemq.network.jms.JmsMesageConvertor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class DestinationBridge
implements Service,
MessageListener {
    private static final Log log = LogFactory.getLog((Class)DestinationBridge.class);
    protected MessageConsumer consumer;
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected JmsMesageConvertor jmsMessageConvertor;
    protected boolean doHandleReplyTo = true;

    DestinationBridge() {
    }

    public MessageConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(MessageConsumer consumer) {
        this.consumer = consumer;
    }

    public JmsMesageConvertor getJmsMessageConvertor() {
        return this.jmsMessageConvertor;
    }

    public void setJmsMessageConvertor(JmsMesageConvertor jmsMessageConvertor) {
        this.jmsMessageConvertor = jmsMessageConvertor;
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            MessageConsumer consumer = this.createConsumer();
            consumer.setMessageListener((MessageListener)this);
            this.createProducer();
        }
    }

    public void stop() throws Exception {
        this.started.set(false);
    }

    public void onMessage(Message message) {
        if (this.started.get() && message != null) {
            try {
                if (this.doHandleReplyTo) {
                    Destination replyTo = message.getJMSReplyTo();
                    if (replyTo != null) {
                        replyTo = this.processReplyToDestination(replyTo);
                        message.setJMSReplyTo(replyTo);
                    }
                } else {
                    message.setJMSReplyTo(null);
                }
                Message converted = this.jmsMessageConvertor.convert(message);
                this.sendMessage(converted);
                message.acknowledge();
            }
            catch (JMSException e) {
                log.error((Object)("failed to forward message: " + message), (Throwable)e);
                try {
                    this.stop();
                }
                catch (Exception e1) {
                    log.warn((Object)"Failed to stop cleanly", (Throwable)e1);
                }
            }
        }
    }

    protected boolean isDoHandleReplyTo() {
        return this.doHandleReplyTo;
    }

    protected void setDoHandleReplyTo(boolean doHandleReplyTo) {
        this.doHandleReplyTo = doHandleReplyTo;
    }

    protected abstract MessageConsumer createConsumer() throws JMSException;

    protected abstract MessageProducer createProducer() throws JMSException;

    protected abstract void sendMessage(Message var1) throws JMSException;

    protected abstract Destination processReplyToDestination(Destination var1);
}

