/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.activeio.ByteArrayOutputStream;
import org.activeio.ByteSequence;
import org.activeio.Packet;
import org.activeio.adapter.PacketToInputStream;
import org.activeio.command.ClassLoading;
import org.activeio.command.WireFormat;
import org.activeio.packet.ByteArrayPacket;
import org.activemq.command.DataStructure;
import org.activemq.command.MarshallAware;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.DataStreamMarshaller;

public final class OpenWireFormat
implements WireFormat {
    static final byte NULL_TYPE = 0;
    private static final int MARSHAL_CACHE_SIZE = 16383;
    private DataStreamMarshaller[] dataMarshallers;
    private int version;
    private boolean stackTraceEnabled = true;
    private boolean tcpNoDelayEnabled = false;
    private boolean cacheEnabled = true;
    private HashMap marshallCacheMap = new HashMap();
    private short nextMarshallCacheIndex = 0;
    private short lasMarshallCacheEvictionIndex = (short)100;
    private DataStructure[] marshallCache = new DataStructure[16383];
    private DataStructure[] unmarshallCache = new DataStructure[16383];

    public OpenWireFormat() {
        this(true);
    }

    public OpenWireFormat(boolean cacheEnabled) {
        this.setVersion(1);
        this.setCacheEnabled(cacheEnabled);
    }

    public int hashCode() {
        return this.version ^ (this.cacheEnabled ? 0x10000000 : 0x20000000) ^ (this.stackTraceEnabled ? 0x30000000 : 0x40000000);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        OpenWireFormat o = (OpenWireFormat)object;
        return o.stackTraceEnabled == this.stackTraceEnabled && o.cacheEnabled == this.cacheEnabled && o.version == this.version;
    }

    public String toString() {
        return "OpenWireFormat{version=" + this.version + ", cacheEnabled=" + this.cacheEnabled + ", stackTraceEnabled=" + this.stackTraceEnabled + "}";
    }

    public int getVersion() {
        return this.version;
    }

    public Packet marshal(Object command) throws IOException {
        MarshallAware ma = null;
        if (!this.cacheEnabled && ((DataStructure)command).isMarshallAware()) {
            ma = (MarshallAware)command;
        }
        ByteSequence sequence = null;
        if (ma != null) {
            sequence = ma.getCachedMarshalledForm(this);
        }
        if (sequence == null) {
            int size = 1;
            if (command != null) {
                DataStructure c = (DataStructure)command;
                byte type = c.getDataStructureType();
                DataStreamMarshaller dsm = this.dataMarshallers[type & 0xFF];
                if (dsm == null) {
                    throw new IOException("Unknown data type: " + type);
                }
                BooleanStream bs = new BooleanStream();
                size += dsm.marshal1(this, c, bs);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(size += bs.marshalledSize());
                DataOutputStream ds = new DataOutputStream((OutputStream)baos);
                ds.writeInt(size);
                ds.writeByte(type);
                bs.marshal(ds);
                dsm.marshal2(this, c, ds, bs);
                ds.close();
                sequence = baos.toByteSequence();
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(5);
                DataOutputStream daos = new DataOutputStream((OutputStream)baos);
                daos.writeInt(size);
                daos.writeByte(0);
                daos.close();
                sequence = baos.toByteSequence();
            }
            if (ma != null) {
                ma.setCachedMarshalledForm(this, sequence);
            }
        }
        return new ByteArrayPacket(sequence);
    }

    public Object unmarshal(Packet packet) throws IOException {
        ByteSequence sequence = packet.asByteSequence();
        DataInputStream dis = new DataInputStream((InputStream)new PacketToInputStream(packet));
        int size = dis.readInt();
        if (sequence.getLength() != size + 4) {
            System.out.println("Packet size does not match marshaled size: " + size + ", " + (sequence.getLength() - 4));
        }
        Object command = this.doUnmarshal(dis);
        if (!this.cacheEnabled && ((DataStructure)command).isMarshallAware()) {
            ((MarshallAware)command).setCachedMarshalledForm(this, sequence);
        }
        return command;
    }

    public void marshal(Object o, DataOutputStream ds) throws IOException {
        int size = 1;
        if (o != null) {
            DataStructure c = (DataStructure)o;
            byte type = c.getDataStructureType();
            DataStreamMarshaller dsm = this.dataMarshallers[type & 0xFF];
            if (dsm == null) {
                throw new IOException("Unknown data type: " + type);
            }
            BooleanStream bs = new BooleanStream();
            size += dsm.marshal1(this, c, bs);
            ds.writeInt(size += bs.marshalledSize());
            ds.writeByte(type);
            bs.marshal(ds);
            dsm.marshal2(this, c, ds, bs);
        } else {
            ds.writeInt(size);
            ds.writeByte(0);
        }
    }

    public Object unmarshal(DataInputStream dis) throws IOException {
        dis.readInt();
        return this.doUnmarshal(dis);
    }

    public void setVersion(int version) {
        Class mfClass;
        String mfName = "org.activemq.openwire.v" + version + ".MarshallerFactory";
        try {
            mfClass = ClassLoading.loadClass((String)mfName, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Invalid version: " + version + ", could not load " + mfName).initCause(e);
        }
        try {
            Method method = mfClass.getMethod("createMarshallerMap", OpenWireFormat.class);
            this.dataMarshallers = (DataStreamMarshaller[])method.invoke(null, this);
        }
        catch (Throwable e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Invalid version: " + version + ", " + mfName + " does not properly implement the createMarshallerMap method.").initCause(e);
        }
        this.version = version;
    }

    public Object doUnmarshal(DataInputStream dis) throws IOException {
        byte dataType = dis.readByte();
        if (dataType != 0) {
            DataStreamMarshaller dsm = this.dataMarshallers[dataType & 0xFF];
            if (dsm == null) {
                throw new IOException("Unknown data type: " + dataType);
            }
            DataStructure data = dsm.createObject();
            BooleanStream bs = new BooleanStream();
            bs.unmarshal(dis);
            dsm.unmarshal(this, data, dis, bs);
            return data;
        }
        return null;
    }

    public int marshal1NestedObject(DataStructure o, BooleanStream bs) throws IOException {
        byte type;
        DataStreamMarshaller dsm;
        bs.writeBoolean(o != null);
        if (o == null) {
            return 0;
        }
        if (o.isMarshallAware()) {
            MarshallAware ma = (MarshallAware)((Object)o);
            ByteSequence sequence = ma.getCachedMarshalledForm(this);
            bs.writeBoolean(sequence != null);
            if (sequence != null) {
                return 1 + sequence.getLength();
            }
        }
        if ((dsm = this.dataMarshallers[(type = o.getDataStructureType()) & 0xFF]) == null) {
            throw new IOException("Unknown data type: " + type);
        }
        return 1 + dsm.marshal1(this, o, bs);
    }

    public void marshal2NestedObject(DataStructure o, DataOutputStream ds, BooleanStream bs) throws IOException {
        if (!bs.readBoolean()) {
            return;
        }
        byte type = o.getDataStructureType();
        ds.writeByte(type);
        if (o.isMarshallAware() && bs.readBoolean()) {
            MarshallAware ma = (MarshallAware)((Object)o);
            ByteSequence sequence = ma.getCachedMarshalledForm(this);
            ds.write(sequence.getData(), sequence.getOffset(), sequence.getLength());
        } else {
            DataStreamMarshaller dsm = this.dataMarshallers[type & 0xFF];
            if (dsm == null) {
                throw new IOException("Unknown data type: " + type);
            }
            dsm.marshal2(this, o, ds, bs);
        }
    }

    public DataStructure unmarshalNestedObject(DataInputStream dis, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            byte dataType = dis.readByte();
            DataStreamMarshaller dsm = this.dataMarshallers[dataType & 0xFF];
            if (dsm == null) {
                throw new IOException("Unknown data type: " + dataType);
            }
            DataStructure data = dsm.createObject();
            if (data.isMarshallAware() && bs.readBoolean()) {
                dis.readInt();
                dis.readByte();
                BooleanStream bs2 = new BooleanStream();
                bs2.unmarshal(dis);
                dsm.unmarshal(this, data, dis, bs2);
            } else {
                dsm.unmarshal(this, data, dis, bs);
            }
            return data;
        }
        return null;
    }

    public Short getMarshallCacheIndex(Object o) {
        return (Short)this.marshallCacheMap.get(o);
    }

    public Short addToMarshallCache(Object o) {
        short s = this.nextMarshallCacheIndex;
        this.nextMarshallCacheIndex = (short)(s + 1);
        Short index = new Short(s);
        if (this.nextMarshallCacheIndex >= 16383) {
            this.nextMarshallCacheIndex = 0;
        }
        this.lasMarshallCacheEvictionIndex = (short)(this.lasMarshallCacheEvictionIndex + 1);
        if (this.lasMarshallCacheEvictionIndex >= 16383) {
            this.lasMarshallCacheEvictionIndex = 0;
        }
        if (this.marshallCache[this.lasMarshallCacheEvictionIndex] != null) {
            this.marshallCacheMap.remove(this.marshallCache[this.lasMarshallCacheEvictionIndex]);
            this.marshallCache[this.lasMarshallCacheEvictionIndex] = null;
        }
        this.marshallCacheMap.put(o, index);
        return index;
    }

    public void setInUnmarshallCache(short index, DataStructure o) {
        this.unmarshallCache[index] = o;
    }

    public DataStructure getFromUnmarshallCache(short index) {
        return this.unmarshallCache[index];
    }

    public void setStackTraceEnabled(boolean b) {
        this.stackTraceEnabled = b;
    }

    public boolean isStackTraceEnabled() {
        return this.stackTraceEnabled;
    }

    public boolean isTcpNoDelayEnabled() {
        return this.tcpNoDelayEnabled;
    }

    public void setTcpNoDelayEnabled(boolean tcpNoDelayEnabled) {
        this.tcpNoDelayEnabled = tcpNoDelayEnabled;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }
}

