/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.BrokerId;
import org.activemq.command.ConnectionId;
import org.activemq.command.ConnectionInfo;
import org.activemq.command.DataStructure;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.openwire.v1.BaseCommandMarshaller;

public class ConnectionInfoMarshaller
extends BaseCommandMarshaller {
    public byte getDataStructureType() {
        return 3;
    }

    public DataStructure createObject() {
        return new ConnectionInfo();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        ConnectionInfo info = (ConnectionInfo)o;
        info.setConnectionId((ConnectionId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setClientId(this.readString(dataIn, bs));
        info.setPassword(this.readString(dataIn, bs));
        info.setUserName(this.readString(dataIn, bs));
        if (bs.readBoolean()) {
            int size = dataIn.readShort();
            BrokerId[] value = new BrokerId[size];
            for (int i = 0; i < size; ++i) {
                value[i] = (BrokerId)this.unmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info.setBrokerPath(value);
        } else {
            info.setBrokerPath(null);
        }
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ConnectionInfo info = (ConnectionInfo)o;
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.marshal1CachedObject(wireFormat, info.getConnectionId(), bs);
        rc += this.writeString(info.getClientId(), bs);
        rc += this.writeString(info.getPassword(), bs);
        rc += this.writeString(info.getUserName(), bs);
        return (rc += this.marshalObjectArray(wireFormat, info.getBrokerPath(), bs)) + 0;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        ConnectionInfo info = (ConnectionInfo)o;
        this.marshal2CachedObject(wireFormat, info.getConnectionId(), dataOut, bs);
        this.writeString(info.getClientId(), dataOut, bs);
        this.writeString(info.getPassword(), dataOut, bs);
        this.writeString(info.getUserName(), dataOut, bs);
        this.marshalObjectArray(wireFormat, info.getBrokerPath(), dataOut, bs);
    }
}

