/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ConsumerId;
import org.activemq.command.DataStructure;
import org.activemq.command.MessageAck;
import org.activemq.command.MessageId;
import org.activemq.command.TransactionId;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.openwire.v1.BaseCommandMarshaller;

public class MessageAckMarshaller
extends BaseCommandMarshaller {
    public byte getDataStructureType() {
        return 22;
    }

    public DataStructure createObject() {
        return new MessageAck();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        MessageAck info = (MessageAck)o;
        info.setDestination((ActiveMQDestination)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setTransactionId((TransactionId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setConsumerId((ConsumerId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setAckType(dataIn.readByte());
        info.setFirstMessageId((MessageId)this.unmarsalNestedObject(wireFormat, dataIn, bs));
        info.setLastMessageId((MessageId)this.unmarsalNestedObject(wireFormat, dataIn, bs));
        info.setMessageCount(dataIn.readInt());
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        MessageAck info = (MessageAck)o;
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.marshal1CachedObject(wireFormat, info.getDestination(), bs);
        rc += this.marshal1CachedObject(wireFormat, info.getTransactionId(), bs);
        rc += this.marshal1CachedObject(wireFormat, info.getConsumerId(), bs);
        rc += this.marshal1NestedObject(wireFormat, info.getFirstMessageId(), bs);
        return (rc += this.marshal1NestedObject(wireFormat, info.getLastMessageId(), bs)) + 5;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        MessageAck info = (MessageAck)o;
        this.marshal2CachedObject(wireFormat, info.getDestination(), dataOut, bs);
        this.marshal2CachedObject(wireFormat, info.getTransactionId(), dataOut, bs);
        this.marshal2CachedObject(wireFormat, info.getConsumerId(), dataOut, bs);
        dataOut.writeByte(info.getAckType());
        this.marshal2NestedObject(wireFormat, info.getFirstMessageId(), dataOut, bs);
        this.marshal2NestedObject(wireFormat, info.getLastMessageId(), dataOut, bs);
        dataOut.writeInt(info.getMessageCount());
    }
}

