/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.DataStructure;
import org.activemq.command.RedeliveryPolicy;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.DataStreamMarshaller;
import org.activemq.openwire.OpenWireFormat;

public class RedeliveryPolicyMarshaller
extends DataStreamMarshaller {
    public byte getDataStructureType() {
        return 13;
    }

    public DataStructure createObject() {
        return new RedeliveryPolicy();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        RedeliveryPolicy info = (RedeliveryPolicy)o;
        info.setBackOffMultiplier(dataIn.readShort());
        info.setInitialRedeliveryDelay(this.unmarshalLong(wireFormat, dataIn, bs));
        info.setMaximumRedeliveries(dataIn.readInt());
        info.setUseExponentialBackOff(bs.readBoolean());
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        RedeliveryPolicy info = (RedeliveryPolicy)o;
        int rc = super.marshal1(wireFormat, o, bs);
        bs.writeBoolean(info.isUseExponentialBackOff());
        return (rc += this.marshal1Long(wireFormat, info.getInitialRedeliveryDelay(), bs)) + 6;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        RedeliveryPolicy info = (RedeliveryPolicy)o;
        dataOut.writeShort(info.getBackOffMultiplier());
        this.marshal2Long(wireFormat, info.getInitialRedeliveryDelay(), dataOut, bs);
        dataOut.writeInt(info.getMaximumRedeliveries());
        bs.readBoolean();
    }
}

