/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.pool;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQSession;
import org.activemq.AlreadyClosedException;
import org.activemq.pool.SessionKey;
import org.activemq.pool.SessionPool;
import org.activemq.util.JMSExceptionSupport;

public class PooledConnection
implements TopicConnection,
QueueConnection {
    private ActiveMQConnection connection;
    private Map cache;
    private boolean stopped;

    public PooledConnection(ActiveMQConnection connection) {
        this(connection, new HashMap());
    }

    public PooledConnection(ActiveMQConnection connection, Map cache) {
        this.connection = connection;
        this.cache = cache;
    }

    public PooledConnection newInstance() {
        return new PooledConnection(this.connection, this.cache);
    }

    public void close() throws JMSException {
        this.connection = null;
        Iterator i = this.cache.values().iterator();
        while (i.hasNext()) {
            SessionPool pool = (SessionPool)i.next();
            i.remove();
            try {
                pool.close();
            }
            catch (Exception e) {
                throw JMSExceptionSupport.create(e);
            }
        }
    }

    public void start() throws JMSException {
        this.getConnection().start();
    }

    public void stop() throws JMSException {
        this.stopped = true;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String selector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(destination, selector, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String s, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(topic, s, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String selector, String s1, ServerSessionPool serverSessionPool, int i) throws JMSException {
        return this.getConnection().createDurableConnectionConsumer(topic, selector, s1, serverSessionPool, i);
    }

    public String getClientID() throws JMSException {
        return this.getConnection().getClientID();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.getConnection().getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.getConnection().getMetaData();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.getConnection().setExceptionListener(exceptionListener);
    }

    public void setClientID(String clientID) throws JMSException {
        this.getConnection().setClientID(clientID);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String selector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(queue, selector, serverSessionPool, maxMessages);
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        return (QueueSession)this.createSession(transacted, ackMode);
    }

    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        return (TopicSession)this.createSession(transacted, ackMode);
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        SessionKey key = new SessionKey(transacted, ackMode);
        SessionPool pool = (SessionPool)this.cache.get(key);
        if (pool == null) {
            pool = new SessionPool(this.getConnection(), key);
            this.cache.put(key, pool);
        }
        return pool.borrowSession();
    }

    protected ActiveMQConnection getConnection() throws JMSException {
        if (this.stopped || this.connection == null) {
            throw new AlreadyClosedException();
        }
        return this.connection;
    }

    protected ActiveMQSession createSession(SessionKey key) throws JMSException {
        return (ActiveMQSession)this.getConnection().createSession(key.isTransacted(), key.getAckMode());
    }
}

