/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store;

import java.io.File;
import java.io.IOException;
import javax.sql.DataSource;
import org.activeio.journal.Journal;
import org.activeio.journal.active.JournalImpl;
import org.activemq.memory.UsageManager;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.PersistenceAdapterFactory;
import org.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.activemq.store.journal.JournalPersistenceAdapter;
import org.activemq.store.journal.QuickJournalPersistenceAdapter;
import org.activemq.thread.TaskRunnerFactory;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class DefaultPersistenceAdapterFactory
implements PersistenceAdapterFactory {
    private int journalLogFileSize = 0x1400000;
    private int journalLogFiles = 2;
    private File dataDirectory;
    private UsageManager memManager;
    private DataSource dataSource;
    private TaskRunnerFactory taskRunnerFactory;
    private Journal journal;
    private boolean useJournal = true;
    private boolean useQuickJournal = false;
    private File journalArchiveDirectory;
    private JDBCPersistenceAdapter jdbcAdapter = new JDBCPersistenceAdapter();

    public PersistenceAdapter createPersistenceAdapter() throws IOException {
        File dataDirectory = this.getDataDirectory();
        this.jdbcAdapter.setDataSource(this.getDataSource());
        if (!this.useJournal) {
            return this.jdbcAdapter;
        }
        if (this.useQuickJournal) {
            return new QuickJournalPersistenceAdapter(this.getJournal(), this.jdbcAdapter, this.getMemManager(), this.getTaskRunnerFactory());
        }
        return new JournalPersistenceAdapter(this.getJournal(), this.jdbcAdapter, this.getMemManager(), this.getTaskRunnerFactory());
    }

    public File getDataDirectory() {
        if (this.dataDirectory == null) {
            this.dataDirectory = new File("activemq-data");
        }
        return this.dataDirectory;
    }

    public void setDataDirectory(File dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public int getJournalLogFiles() {
        return this.journalLogFiles;
    }

    public void setJournalLogFiles(int journalLogFiles) {
        this.journalLogFiles = journalLogFiles;
    }

    public int getJournalLogFileSize() {
        return this.journalLogFileSize;
    }

    public void setJournalLogFileSize(int journalLogFileSize) {
        this.journalLogFileSize = journalLogFileSize;
    }

    public UsageManager getMemManager() {
        if (this.memManager == null) {
            this.memManager = new UsageManager();
        }
        return this.memManager;
    }

    public void setMemManager(UsageManager memManager) {
        this.memManager = memManager;
    }

    public DataSource getDataSource() throws IOException {
        if (this.dataSource == null) {
            this.dataSource = this.createDataSource();
        }
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JDBCPersistenceAdapter getJdbcAdapter() {
        return this.jdbcAdapter;
    }

    public void setJdbcAdapter(JDBCPersistenceAdapter jdbcAdapter) {
        this.jdbcAdapter = jdbcAdapter;
    }

    public boolean isUseJournal() {
        return this.useJournal;
    }

    public void setUseJournal(boolean useJournal) {
        this.useJournal = useJournal;
    }

    public TaskRunnerFactory getTaskRunnerFactory() {
        if (this.taskRunnerFactory == null) {
            this.taskRunnerFactory = new TaskRunnerFactory();
        }
        return this.taskRunnerFactory;
    }

    public void setTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.taskRunnerFactory = taskRunnerFactory;
    }

    public Journal getJournal() throws IOException {
        if (this.journal == null) {
            this.createJournal();
        }
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public File getJournalArchiveDirectory() {
        if (this.journalArchiveDirectory == null && this.useQuickJournal) {
            this.journalArchiveDirectory = new File(this.getDataDirectory(), "journal");
        }
        return this.journalArchiveDirectory;
    }

    public void setJournalArchiveDirectory(File journalArchiveDirectory) {
        this.journalArchiveDirectory = journalArchiveDirectory;
    }

    public boolean isUseQuickJournal() {
        return this.useQuickJournal;
    }

    public void setUseQuickJournal(boolean useQuickJournal) {
        this.useQuickJournal = useQuickJournal;
    }

    protected DataSource createDataSource() throws IOException {
        System.setProperty("derby.system.home", this.getDataDirectory().getCanonicalPath());
        System.setProperty("derby.storage.fileSyncTransactionLog", "true");
        System.setProperty("derby.storage.pageCacheSize", "100");
        EmbeddedDataSource ds = new EmbeddedDataSource();
        ds.setDatabaseName("derbydb");
        ds.setCreateDatabase("create");
        return ds;
    }

    protected void createJournal() throws IOException {
        File journalDir = new File(this.getDataDirectory(), "journal");
        this.journal = new JournalImpl(journalDir, this.journalLogFiles, this.journalLogFileSize, this.getJournalArchiveDirectory());
    }
}

