/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.memory;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.activemq.broker.ConnectionContext;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.Message;
import org.activemq.command.MessageId;
import org.activemq.command.SubscriptionInfo;
import org.activemq.store.MessageRecoveryListener;
import org.activemq.store.TopicMessageStore;
import org.activemq.store.memory.MemoryMessageStore;
import org.activemq.util.SubscriptionKey;

public class MemoryTopicMessageStore
extends MemoryMessageStore
implements TopicMessageStore {
    private Map ackDatabase;
    private Map subscriberDatabase;
    MessageId lastMessageId;
    static /* synthetic */ Class class$java$lang$String;

    public MemoryTopicMessageStore(ActiveMQDestination destination) {
        this(destination, new LinkedHashMap(), MemoryTopicMessageStore.makeMap(), MemoryTopicMessageStore.makeMap());
    }

    protected static Map makeMap() {
        return Collections.synchronizedMap(new HashMap());
    }

    public MemoryTopicMessageStore(ActiveMQDestination destination, Map messageTable, Map subscriberDatabase, Map ackDatabase) {
        super(destination, messageTable);
        this.subscriberDatabase = subscriberDatabase;
        this.ackDatabase = ackDatabase;
    }

    public synchronized void addMessage(ConnectionContext context, Message message) throws IOException {
        super.addMessage(context, message);
        this.lastMessageId = message.getMessageId();
    }

    public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId) throws IOException {
        this.ackDatabase.put(new SubscriptionKey(clientId, subscriptionName), messageId);
    }

    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        return (SubscriptionInfo)this.subscriberDatabase.get(new SubscriptionKey(clientId, subscriptionName));
    }

    public void addSubsciption(String clientId, String subscriptionName, String selector, boolean retroactive) throws IOException {
        MessageId l;
        SubscriptionInfo info = new SubscriptionInfo();
        info.setDestination(this.destination);
        info.setClientId(clientId);
        info.setSelector(selector);
        info.setSubcriptionName(subscriptionName);
        SubscriptionKey key = new SubscriptionKey(clientId, subscriptionName);
        this.subscriberDatabase.put(key, info);
        MessageId messageId = l = retroactive ? null : this.lastMessageId;
        if (l != null) {
            this.ackDatabase.put(key, l);
        }
    }

    public void deleteSubscription(String clientId, String subscriptionName) {
        SubscriptionKey key = new SubscriptionKey(clientId, subscriptionName);
        this.ackDatabase.remove(key);
        this.subscriberDatabase.remove(key);
    }

    public void recoverSubscription(String clientId, String subscriptionName, MessageRecoveryListener listener) throws Throwable {
        MessageId lastAck = (MessageId)this.ackDatabase.get(new SubscriptionKey(clientId, subscriptionName));
        boolean pastLastAck = lastAck == null;
        Iterator iter = this.messageTable.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (pastLastAck) {
                Object msg = entry.getValue();
                if (msg.getClass() == (class$java$lang$String == null ? MemoryTopicMessageStore.class$("java.lang.String") : class$java$lang$String)) {
                    listener.recoverMessageReference((String)msg);
                    continue;
                }
                listener.recoverMessage((Message)msg);
                continue;
            }
            pastLastAck = entry.getKey().equals(lastAck);
        }
    }

    public void delete() {
        super.delete();
        this.ackDatabase.clear();
        this.subscriberDatabase.clear();
        this.lastMessageId = null;
    }
}

