/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.thread;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.SynchronousQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.activemq.thread.SimpleTaskRunner;
import org.activemq.thread.Task;
import org.activemq.thread.TaskRunner;

public class TaskRunnerFactory {
    private Executor executor;
    private int maxIterationsPerRun = 1000;

    public TaskRunnerFactory() {
        this.setExecutor(this.createDefaultExecutor("ActiveMQ Task", 5, true));
    }

    public TaskRunnerFactory(String name, int priority, boolean daemon, int maxIterationsPerRun) {
        this.maxIterationsPerRun = maxIterationsPerRun;
        this.setExecutor(this.createDefaultExecutor(name, priority, daemon));
    }

    public TaskRunnerFactory(Executor executor, int maxIterationsPerRun) {
        this.executor = executor;
        this.maxIterationsPerRun = maxIterationsPerRun;
    }

    public TaskRunner createTaskRunner(Task task) {
        return new SimpleTaskRunner(this.executor, task, this.maxIterationsPerRun);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public int getMaxIterationsPerRun() {
        return this.maxIterationsPerRun;
    }

    public void setMaxIterationsPerRun(int maxIterationsPerRun) {
        this.maxIterationsPerRun = maxIterationsPerRun;
    }

    protected Executor createDefaultExecutor(final String name, final int priority, final boolean daemon) {
        ThreadPoolExecutor rc = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue(), new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, name);
                thread.setDaemon(daemon);
                thread.setPriority(priority);
                return thread;
            }
        });
        rc.allowCoreThreadTimeOut(true);
        return rc;
    }
}

