/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import org.activemq.command.Command;
import org.activemq.command.Response;
import org.activemq.transport.FutureResponse;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ResponseCorrelator
extends TransportFilter {
    private static final Log log = LogFactory.getLog((Class)ResponseCorrelator.class);
    private final ConcurrentHashMap requestMap = new ConcurrentHashMap();
    private short lastCommandId = 0;

    synchronized short getNextCommandId() {
        this.lastCommandId = (short)(this.lastCommandId + 1);
        return this.lastCommandId;
    }

    public ResponseCorrelator(Transport next) {
        super(next);
    }

    public void oneway(Command command) throws IOException {
        command.setCommandId(this.getNextCommandId());
        command.setResponseRequired(false);
        this.next.oneway(command);
    }

    public FutureResponse asyncRequest(Command command) throws IOException {
        command.setCommandId(this.getNextCommandId());
        command.setResponseRequired(true);
        FutureResponse future = new FutureResponse();
        this.requestMap.put((Object)new Short(command.getCommandId()), (Object)future);
        this.next.oneway(command);
        return future;
    }

    public Response request(Command command) throws IOException {
        FutureResponse response = this.asyncRequest(command);
        return response.getResult();
    }

    public void onCommand(Command command) {
        boolean debug = log.isDebugEnabled();
        if (command.isResponse()) {
            Response response = (Response)command;
            FutureResponse future = (FutureResponse)((Object)this.requestMap.remove((Object)new Short(response.getCorrelationId())));
            if (future != null) {
                future.set(response);
            } else if (debug) {
                log.debug((Object)("Received unexpected response for command id: " + response.getCorrelationId()));
            }
        } else {
            this.commandListener.onCommand(command);
        }
    }
}

