/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.discovery;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.activemq.command.DiscoveryEvent;
import org.activemq.transport.CompositeTransport;
import org.activemq.transport.TransportFilter;
import org.activemq.transport.discovery.DiscoveryAgent;
import org.activemq.transport.discovery.DiscoveryListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiscoveryTransport
extends TransportFilter
implements DiscoveryListener {
    private static final Log log = LogFactory.getLog((Class)DiscoveryTransport.class);
    private final CompositeTransport next;
    private DiscoveryAgent discoveryAgent;
    private final ConcurrentHashMap serviceURIs = new ConcurrentHashMap();

    public DiscoveryTransport(CompositeTransport next) {
        super(next);
        this.next = next;
    }

    public void start() throws Exception {
        if (this.discoveryAgent == null) {
            throw new IllegalStateException("discoveryAgent not configured");
        }
        this.discoveryAgent.setDiscoveryListener(this);
        this.discoveryAgent.start();
        this.next.start();
    }

    public void stop() throws Exception {
        IOException firstError;
        block5: {
            firstError = null;
            try {
                this.discoveryAgent.stop();
            }
            catch (IOException e) {
                firstError = e;
            }
            try {
                this.next.stop();
            }
            catch (IOException e) {
                if (firstError == null) break block5;
                firstError = e;
            }
        }
        if (firstError != null) {
            throw firstError;
        }
    }

    public void onServiceAdd(DiscoveryEvent event) {
        String url = event.getServiceName();
        if (url != null) {
            try {
                URI uri = new URI(url);
                this.serviceURIs.put((Object)event.getServiceName(), (Object)uri);
                log.info((Object)("Adding new broker connection URL: " + uri));
                this.next.add(new URI[]{uri});
            }
            catch (URISyntaxException e) {
                log.warn((Object)("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e), (Throwable)e);
            }
        }
    }

    public void onServiceRemove(DiscoveryEvent event) {
        URI uri = (URI)this.serviceURIs.get((Object)event.getServiceName());
        if (uri != null) {
            this.next.remove(new URI[]{uri});
        }
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
    }
}

