/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.discovery;

import java.util.HashMap;
import org.activemq.command.BrokerInfo;
import org.activemq.transport.TransportServer;
import org.activemq.transport.TransportServerFilter;
import org.activemq.transport.discovery.DiscoveryAgent;

public class DiscoveryTransportServer
extends TransportServerFilter {
    private String discovery = "multicast";
    private DiscoveryAgent discoveryAgent;
    private BrokerInfo brokerInfo;

    public DiscoveryTransportServer(TransportServer next) {
        super(next);
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
        this.brokerInfo = brokerInfo;
        super.setBrokerInfo(brokerInfo);
    }

    public String getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(String discovery) {
        this.discovery = discovery;
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
    }

    public void start() throws Exception {
        if (this.brokerInfo == null) {
            throw new IllegalStateException("brokerInfo must be set before starting.");
        }
        HashMap<String, String> details = new HashMap<String, String>();
        String brokerId = this.brokerInfo.getBrokerId().toString();
        details.put("brokerId", brokerId);
        details.put("connectURL", this.getConnectURI().toString());
        this.next.start();
        this.discoveryAgent.start();
        this.discoveryAgent.registerService(this.getConnectURI().toString());
    }

    public void stop() throws Exception {
        this.next.stop();
        this.discoveryAgent.stop();
    }
}

