/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.https;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jms.JMSException;
import org.activemq.io.WireFormat;
import org.activemq.transport.TransportChannel;
import org.activemq.transport.http.HttpTransportChannelFactory;
import org.activemq.transport.https.HttpsTransportChannel;
import org.activemq.util.JMSExceptionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpsTransportChannelFactory
extends HttpTransportChannelFactory {
    private static final Log log = LogFactory.getLog((Class)HttpsTransportChannelFactory.class);

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation) throws JMSException {
        try {
            return this.create(wireFormat, remoteLocation, new URI("https://localhost:0"));
        }
        catch (URISyntaxException e) {
            throw JMSExceptionHelper.newJMSException((String)e.getMessage(), (Exception)e);
        }
    }

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation, URI localLocation) throws JMSException {
        try {
            HttpsTransportChannel channel = new HttpsTransportChannel(this.asTextWireFormat(wireFormat), remoteLocation.toString());
            return this.populateProperties((TransportChannel)channel, remoteLocation);
        }
        catch (MalformedURLException e) {
            throw JMSExceptionHelper.newJMSException((String)e.getMessage(), (Exception)e);
        }
    }
}

