/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.https;

import java.net.URI;
import javax.jms.JMSException;
import org.activemq.transport.http.HttpTransportConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.SocketListener;
import org.mortbay.http.SslListener;

public class HttpsTransportConnector
extends HttpTransportConnector {
    private static final Log log = LogFactory.getLog((Class)HttpsTransportConnector.class);
    private String keyPassword = System.getProperty("javax.net.ssl.keyPassword");
    private String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
    private String keyStore = System.getProperty("javax.net.ssl.keyStore");
    private String keyStoreType = null;
    private String certificateAlgorithm = null;
    private String protocol = null;

    public HttpsTransportConnector(URI uri) {
        super(uri);
    }

    public void start() throws JMSException {
        SslListener sslListener = new SslListener();
        sslListener.setKeystore(this.keyStore);
        sslListener.setPassword(this.keyStorePassword);
        if (this.keyPassword == null) {
            sslListener.setKeyPassword(this.keyStorePassword);
        }
        if (this.keyStoreType != null) {
            sslListener.setKeystoreType(this.keyStoreType);
        }
        if (this.certificateAlgorithm != null) {
            sslListener.setAlgorithm(this.certificateAlgorithm);
        }
        if (this.protocol != null) {
            sslListener.setProtocol(this.protocol);
        }
        this.setSocketListener((SocketListener)sslListener);
        super.start();
    }

    public String getCertificateAlgorithm() {
        return this.certificateAlgorithm;
    }

    public void setCertificateAlgorithm(String certificateAlgorithm) {
        this.certificateAlgorithm = certificateAlgorithm;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

