/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.ra;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.ActiveMQTopic;
import org.activemq.ra.ActiveMQResourceAdapter;
import org.activemq.selector.SelectorParser;

public class ActiveMQActivationSpec
implements ActivationSpec {
    public static final String AUTO_ACKNOWLEDGE_MODE = "Auto-acknowledge";
    public static final String DUPS_OK_ACKNOWLEDGE_MODE = "Dups-ok-acknowledge";
    public static final String DURABLE_SUBSCRIPTION = "Durable";
    public static final String NON_DURABLE_SUBSCRIPTION = "NonDurable";
    public static final int INVALID_ACKNOWLEDGE_MODE = -1;
    private ActiveMQResourceAdapter resourceAdapter;
    private String destinationType;
    private String messageSelector;
    private String destination;
    private String acknowledgeMode = "Auto-acknowledge";
    private String userName;
    private String password;
    private String clientId;
    private String subscriptionName;
    private String subscriptionDurability = "NonDurable";
    private String noLocal = "false";
    private String useRAManagedTransaction = "false";
    private String maxSessions = "10";
    private String maxMessagesPerSessions = "10";
    private String enableBatch = "false";
    private String maxMessagesPerBatch = "10";
    static final /* synthetic */ boolean $assertionsDisabled;

    public void validate() throws InvalidPropertyException {
        ArrayList errorMessages = new ArrayList();
        ArrayList<PropertyDescriptor> propsNotSet = new ArrayList<PropertyDescriptor>();
        try {
            if (!this.isValidDestination(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("destination", ActiveMQActivationSpec.class));
            }
            if (!this.isValidDestinationType(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("destinationType", ActiveMQActivationSpec.class));
            }
            if (!this.isValidAcknowledgeMode(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("acknowledgeMode", ActiveMQActivationSpec.class));
            }
            if (!this.isValidSubscriptionDurability(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("subscriptionDurability", ActiveMQActivationSpec.class));
            }
            if (!this.isValidClientId(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("clientId", ActiveMQActivationSpec.class));
            }
            if (!this.isValidSubscriptionName(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("subscriptionName", ActiveMQActivationSpec.class));
            }
            if (!this.isValidMaxMessagesPerSessions(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("maxMessagesPerSessions", ActiveMQActivationSpec.class));
            }
            if (!this.isValidMaxSessions(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("maxSessions", ActiveMQActivationSpec.class));
            }
            if (!this.isValidMessageSelector(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("messageSelector", ActiveMQActivationSpec.class));
            }
            if (!this.isValidNoLocal(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("noLocal", ActiveMQActivationSpec.class));
            }
            if (!this.isValidUseRAManagedTransaction(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("useRAManagedTransaction", ActiveMQActivationSpec.class));
            }
            if (!this.isValidEnableBatch(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("enableBatch", ActiveMQActivationSpec.class));
            }
            if (!this.isValidMaxMessagesPerBatch(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("maxMessagesPerBatch", ActiveMQActivationSpec.class));
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        if (propsNotSet.size() > 0) {
            StringBuffer b = new StringBuffer();
            b.append("Invalid settings:");
            Iterator iter = errorMessages.iterator();
            while (iter.hasNext()) {
                b.append(" ");
                b.append(iter.next());
            }
            InvalidPropertyException e = new InvalidPropertyException(b.toString());
            PropertyDescriptor[] descriptors = propsNotSet.toArray(new PropertyDescriptor[propsNotSet.size()]);
            e.setInvalidPropertyDescriptors(descriptors);
            throw e;
        }
    }

    private boolean isValidUseRAManagedTransaction(List errorMessages) {
        try {
            new Boolean(this.noLocal);
            return true;
        }
        catch (Throwable throwable) {
            errorMessages.add("noLocal must be set to: true or false.");
            return false;
        }
    }

    private boolean isValidNoLocal(List errorMessages) {
        try {
            new Boolean(this.noLocal);
            return true;
        }
        catch (Throwable throwable) {
            errorMessages.add("noLocal must be set to: true or false.");
            return false;
        }
    }

    private boolean isValidMessageSelector(List errorMessages) {
        try {
            if (!this.isEmpty(this.messageSelector)) {
                new SelectorParser().parse(this.messageSelector);
            }
            return true;
        }
        catch (Throwable e) {
            errorMessages.add("messageSelector not set to valid message selector: " + e.getMessage());
            return false;
        }
    }

    private boolean isValidMaxSessions(List errorMessages) {
        try {
            if (Integer.parseInt(this.maxSessions) > 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        errorMessages.add("maxSessions must be set to number > 0");
        return false;
    }

    private boolean isValidMaxMessagesPerSessions(List errorMessages) {
        try {
            if (Integer.parseInt(this.maxMessagesPerSessions) > 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        errorMessages.add("maxMessagesPerSessions must be set to number > 0");
        return false;
    }

    private boolean isValidMaxMessagesPerBatch(List errorMessages) {
        try {
            if (Integer.parseInt(this.maxMessagesPerBatch) > 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        errorMessages.add("maxMessagesPerBatch must be set to number > 0");
        return false;
    }

    private boolean isValidEnableBatch(List errorMessages) {
        try {
            new Boolean(this.enableBatch);
            return true;
        }
        catch (Throwable throwable) {
            errorMessages.add("enableBatch must be set to: true or false");
            return false;
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) throws ResourceException {
        if (this.resourceAdapter != null) {
            throw new ResourceException("ResourceAdapter already set");
        }
        if (!(resourceAdapter instanceof ActiveMQResourceAdapter)) {
            throw new ResourceException("ResourceAdapter is not of type: " + ActiveMQResourceAdapter.class.getName());
        }
        this.resourceAdapter = (ActiveMQResourceAdapter)resourceAdapter;
    }

    public String getDestinationType() {
        if (!this.isEmpty(this.destinationType)) {
            return this.destinationType;
        }
        return null;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getPassword() {
        if (!this.isEmpty(this.password)) {
            return this.password;
        }
        return null;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        if (!this.isEmpty(this.userName)) {
            return this.userName;
        }
        return null;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getMessageSelector() {
        if (!this.isEmpty(this.messageSelector)) {
            return this.messageSelector;
        }
        return null;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public String getNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(String noLocal) {
        if (noLocal != null) {
            this.noLocal = noLocal;
        }
    }

    public String getAcknowledgeMode() {
        if (!this.isEmpty(this.acknowledgeMode)) {
            return this.acknowledgeMode;
        }
        return null;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public String getClientId() {
        if (!this.isEmpty(this.clientId)) {
            return this.clientId;
        }
        return null;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getDestination() {
        if (!this.isEmpty(this.destination)) {
            return this.destination;
        }
        return null;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getSubscriptionDurability() {
        if (!this.isEmpty(this.subscriptionDurability)) {
            return this.subscriptionDurability;
        }
        return null;
    }

    public void setSubscriptionDurability(String subscriptionDurability) {
        this.subscriptionDurability = subscriptionDurability;
    }

    public String getSubscriptionName() {
        if (!this.isEmpty(this.subscriptionName)) {
            return this.subscriptionName;
        }
        return null;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    private boolean isValidSubscriptionName(List errorMessages) {
        if (!this.isDurableSubscription() || this.subscriptionName != null && this.subscriptionName.trim().length() > 0) {
            return true;
        }
        errorMessages.add("subscriptionName must be set since durable subscription was requested.");
        return false;
    }

    private boolean isValidClientId(List errorMessages) {
        if (!this.isDurableSubscription() || this.clientId != null && this.clientId.trim().length() > 0) {
            return true;
        }
        errorMessages.add("clientId must be set since durable subscription was requested.");
        return false;
    }

    public boolean isDurableSubscription() {
        return DURABLE_SUBSCRIPTION.equals(this.subscriptionDurability);
    }

    private boolean isValidSubscriptionDurability(List errorMessages) {
        if (NON_DURABLE_SUBSCRIPTION.equals(this.subscriptionDurability) || DURABLE_SUBSCRIPTION.equals(this.subscriptionDurability)) {
            return true;
        }
        errorMessages.add("subscriptionDurability must be set to: NonDurable or Durable.");
        return false;
    }

    private boolean isValidAcknowledgeMode(List errorMessages) {
        if (AUTO_ACKNOWLEDGE_MODE.equals(this.acknowledgeMode) || DUPS_OK_ACKNOWLEDGE_MODE.equals(this.acknowledgeMode)) {
            return true;
        }
        errorMessages.add("acknowledgeMode must be set to: Auto-acknowledge or Dups-ok-acknowledge.");
        return false;
    }

    private boolean isValidDestinationType(List errorMessages) {
        if (Queue.class.getName().equals(this.destinationType) || Topic.class.getName().equals(this.destinationType)) {
            return true;
        }
        errorMessages.add("destinationType must be set to: " + Queue.class.getName() + " or " + Topic.class.getName() + ".");
        return false;
    }

    private boolean isValidDestination(List errorMessages) {
        if (this.destination != null && !this.destination.equals("")) {
            return true;
        }
        errorMessages.add("destination is a required field and must be set to the destination name.");
        return false;
    }

    private boolean isEmpty(String value) {
        return value == null || "".equals(value.trim());
    }

    public String toString() {
        return "ActiveMQActivationSpec{acknowledgeMode='" + this.acknowledgeMode + "'" + ", destinationType='" + this.destinationType + "'" + ", messageSelector='" + this.messageSelector + "'" + ", destination='" + this.destination + "'" + ", clientId='" + this.clientId + "'" + ", subscriptionName='" + this.subscriptionName + "'" + ", subscriptionDurability='" + this.subscriptionDurability + "'" + "}";
    }

    public int getAcknowledgeModeForSession() {
        if (AUTO_ACKNOWLEDGE_MODE.equals(this.acknowledgeMode)) {
            return 1;
        }
        if (DUPS_OK_ACKNOWLEDGE_MODE.equals(this.acknowledgeMode)) {
            return 3;
        }
        return -1;
    }

    public ActiveMQDestination createDestination() {
        if (this.isEmpty(this.destinationType) || this.isEmpty(this.destination)) {
            return null;
        }
        ActiveMQQueue dest = null;
        if (Queue.class.getName().equals(this.destinationType)) {
            dest = new ActiveMQQueue(this.destination);
        } else if (Topic.class.getName().equals(this.destinationType)) {
            dest = new ActiveMQTopic(this.destination);
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Execution should never reach here");
        }
        return dest;
    }

    public String getMaxMessagesPerSessions() {
        return this.maxMessagesPerSessions.toString();
    }

    public void setMaxMessagesPerSessions(String maxMessagesPerSessions) {
        if (maxMessagesPerSessions != null) {
            this.maxMessagesPerSessions = maxMessagesPerSessions;
        }
    }

    public String getMaxSessions() {
        return this.maxSessions;
    }

    public void setMaxSessions(String maxSessions) {
        if (maxSessions != null) {
            this.maxSessions = maxSessions;
        }
    }

    public String getUseRAManagedTransaction() {
        return this.useRAManagedTransaction;
    }

    public void setUseRAManagedTransaction(String useRAManagedTransaction) {
        if (useRAManagedTransaction != null) {
            this.useRAManagedTransaction = useRAManagedTransaction;
        }
    }

    public int getMaxMessagesPerSessionsIntValue() {
        return Integer.parseInt(this.maxMessagesPerSessions);
    }

    public int getMaxSessionsIntValue() {
        return Integer.parseInt(this.maxSessions);
    }

    public boolean isUseRAManagedTransactionEnabled() {
        return new Boolean(this.useRAManagedTransaction);
    }

    public boolean getNoLocalBooleanValue() {
        return new Boolean(this.noLocal);
    }

    public String getEnableBatch() {
        return this.enableBatch;
    }

    public void setEnableBatch(String enableBatch) {
        if (enableBatch != null) {
            this.enableBatch = enableBatch;
        }
    }

    public boolean getEnableBatchBooleanValue() {
        return new Boolean(this.enableBatch);
    }

    public int getMaxMessagesPerBatchIntValue() {
        return Integer.parseInt(this.maxMessagesPerBatch);
    }

    public String getMaxMessagesPerBatch() {
        return this.maxMessagesPerBatch.toString();
    }

    public void setMaxMessagesPerBatch(String maxMessagesPerBatch) {
        if (maxMessagesPerBatch != null) {
            this.maxMessagesPerBatch = maxMessagesPerBatch;
        }
    }

    static {
        $assertionsDisabled = !ActiveMQActivationSpec.class.desiredAssertionStatus();
    }
}

