/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.ra;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.activemq.ActiveMQConnection;
import org.activemq.LocalTransactionEventListener;
import org.activemq.TransactionContext;
import org.activemq.ra.ActiveMQConnectionRequestInfo;
import org.activemq.ra.LocalAndXATransaction;
import org.activemq.ra.ManagedConnectionProxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQManagedConnection
implements ManagedConnection,
ExceptionListener {
    private static final Log log = LogFactory.getLog((Class)ActiveMQManagedConnection.class);
    private PrintWriter logWriter;
    private final ActiveMQConnection physicalConnection;
    private final TransactionContext transactionContext;
    private final ArrayList proxyConnections = new ArrayList();
    private final ArrayList listeners = new ArrayList();
    private final LocalAndXATransaction localAndXATransaction;
    private Subject subject;
    private ActiveMQConnectionRequestInfo info;
    private boolean destoryed;

    public ActiveMQManagedConnection(Subject subject, ActiveMQConnection physicalConnection, ActiveMQConnectionRequestInfo info) throws ResourceException {
        try {
            this.subject = subject;
            this.info = info;
            this.physicalConnection = physicalConnection;
            this.transactionContext = new TransactionContext(physicalConnection);
            this.localAndXATransaction = new LocalAndXATransaction(this.transactionContext){

                public void setInManagedTx(boolean inManagedTx) throws JMSException {
                    super.setInManagedTx(inManagedTx);
                    Iterator iterator = ActiveMQManagedConnection.this.proxyConnections.iterator();
                    while (iterator.hasNext()) {
                        ManagedConnectionProxy proxy = (ManagedConnectionProxy)iterator.next();
                        proxy.setUseSharedTxContext(inManagedTx);
                    }
                }
            };
            this.transactionContext.setLocalTransactionEventListener(new LocalTransactionEventListener(){

                public void beginEvent() {
                    ActiveMQManagedConnection.this.fireBeginEvent();
                }

                public void commitEvent() {
                    ActiveMQManagedConnection.this.fireCommitEvent();
                }

                public void rollbackEvent() {
                    ActiveMQManagedConnection.this.fireRollbackEvent();
                }
            });
            physicalConnection.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException e) {
            throw new ResourceException("Could not create a new connection: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isInManagedTx() {
        return this.localAndXATransaction.isInManagedTx();
    }

    public static boolean matches(Object x, Object y) {
        if (x == null ^ y == null) {
            return false;
        }
        return x == null || x.equals(y);
    }

    public void associate(Subject subject, ActiveMQConnectionRequestInfo info) throws JMSException {
        if (!ActiveMQManagedConnection.matches(info.getUserName(), this.info.getUserName()) || !ActiveMQManagedConnection.matches(info.getPassword(), this.info.getPassword())) {
            this.physicalConnection.changeUserInfo(info.getUserName(), info.getPassword());
        }
        if (info.getClientid() != null && info.getClientid().length() > 0) {
            this.physicalConnection.setClientID(info.getClientid());
        }
        this.subject = subject;
        this.info = info;
    }

    public Connection getPhysicalConnection() {
        return this.physicalConnection;
    }

    private void fireBeginEvent() {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 2);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener l = (ConnectionEventListener)iterator.next();
            l.localTransactionStarted(event);
        }
    }

    private void fireCommitEvent() {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 3);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener l = (ConnectionEventListener)iterator.next();
            l.localTransactionCommitted(event);
        }
    }

    private void fireRollbackEvent() {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 4);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener l = (ConnectionEventListener)iterator.next();
            l.localTransactionRolledback(event);
        }
    }

    private void fireCloseEvent(ManagedConnectionProxy proxy) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)proxy);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener l = (ConnectionEventListener)iterator.next();
            l.connectionClosed(event);
        }
    }

    private void fireErrorOccurredEvent(Exception error) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, error);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener l = (ConnectionEventListener)iterator.next();
            l.connectionErrorOccurred(event);
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        ManagedConnectionProxy proxy = new ManagedConnectionProxy(this);
        this.proxyConnections.add(proxy);
        return proxy;
    }

    private boolean isDestroyed() {
        return this.destoryed;
    }

    public void destroy() throws ResourceException {
        if (this.isDestroyed()) {
            return;
        }
        this.cleanup();
        try {
            this.physicalConnection.close();
            this.destoryed = true;
        }
        catch (JMSException e) {
            log.info((Object)"Error occured during close of a JMS connection.", (Throwable)e);
        }
    }

    public void cleanup() throws ResourceException {
        if (this.isDestroyed()) {
            return;
        }
        Iterator iterator = this.proxyConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnectionProxy proxy = (ManagedConnectionProxy)iterator.next();
            proxy.cleanup();
        }
        this.proxyConnections.clear();
        this.localAndXATransaction.cleanup();
        try {
            this.physicalConnection.cleanup();
        }
        catch (JMSException e) {
            throw new ResourceException("Could cleanup the ActiveMQ connection: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public void associateConnection(Object connection) throws ResourceException {
        throw new ResourceException("Not supported.");
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    public XAResource getXAResource() throws ResourceException {
        return this.localAndXATransaction;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.localAndXATransaction;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new ManagedConnectionMetaData(){

            public String getEISProductName() throws ResourceException {
                if (ActiveMQManagedConnection.this.physicalConnection == null) {
                    throw new ResourceException("Not connected.");
                }
                try {
                    return ActiveMQManagedConnection.this.physicalConnection.getMetaData().getJMSProviderName();
                }
                catch (JMSException e) {
                    throw new ResourceException("Error accessing provider.", (Throwable)e);
                }
            }

            public String getEISProductVersion() throws ResourceException {
                if (ActiveMQManagedConnection.this.physicalConnection == null) {
                    throw new ResourceException("Not connected.");
                }
                try {
                    return ActiveMQManagedConnection.this.physicalConnection.getMetaData().getProviderVersion();
                }
                catch (JMSException e) {
                    throw new ResourceException("Error accessing provider.", (Throwable)e);
                }
            }

            public int getMaxConnections() throws ResourceException {
                if (ActiveMQManagedConnection.this.physicalConnection == null) {
                    throw new ResourceException("Not connected.");
                }
                return Integer.MAX_VALUE;
            }

            public String getUserName() throws ResourceException {
                if (ActiveMQManagedConnection.this.physicalConnection == null) {
                    throw new ResourceException("Not connected.");
                }
                try {
                    return ActiveMQManagedConnection.this.physicalConnection.getClientID();
                }
                catch (JMSException e) {
                    throw new ResourceException("Error accessing provider.", (Throwable)e);
                }
            }
        };
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.logWriter = logWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public boolean matches(Subject subject, ConnectionRequestInfo info) {
        if (info == null) {
            return false;
        }
        if (info.getClass() != ActiveMQConnectionRequestInfo.class) {
            return false;
        }
        if (subject == null ^ this.subject == null) {
            return false;
        }
        if (subject != null && !subject.equals(this.subject)) {
            return false;
        }
        return info.equals(this.info);
    }

    public void proxyClosedEvent(ManagedConnectionProxy proxy) {
        this.proxyConnections.remove(proxy);
        proxy.cleanup();
        this.fireCloseEvent(proxy);
    }

    public void onException(JMSException e) {
        log.warn((Object)("Connection failed: " + (Object)((Object)e)));
        log.debug((Object)"Cause: ", (Throwable)e);
        Iterator iter = this.proxyConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnectionProxy proxy = (ManagedConnectionProxy)iter.next();
            proxy.onException(e);
        }
        this.fireErrorOccurredEvent((Exception)((Object)e));
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }
}

