/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.ra;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.security.auth.Subject;
import org.activemq.ra.ActiveMQConnectionFactory;
import org.activemq.ra.ActiveMQConnectionRequestInfo;
import org.activemq.ra.ActiveMQManagedConnection;
import org.activemq.ra.ActiveMQResourceAdapter;
import org.activemq.ra.SimpleConnectionManager;

public class ActiveMQManagedConnectionFactory
implements ManagedConnectionFactory,
ResourceAdapterAssociation {
    private static final long serialVersionUID = 6196921962230582875L;
    private ActiveMQResourceAdapter adapter;
    private PrintWriter logWriter;
    private ActiveMQConnectionRequestInfo info = new ActiveMQConnectionRequestInfo();

    public void setResourceAdapter(ResourceAdapter adapter) throws ResourceException {
        this.adapter = (ActiveMQResourceAdapter)adapter;
        ActiveMQConnectionRequestInfo baseInfo = this.adapter.getInfo().copy();
        if (this.info.getClientid() == null) {
            this.info.setClientid(baseInfo.getClientid());
        }
        if (this.info.getPassword() == null) {
            this.info.setPassword(baseInfo.getPassword());
        }
        if (this.info.getServerUrl() == null) {
            this.info.setServerUrl(baseInfo.getServerUrl());
        }
        if (this.info.getUseInboundSession() == null) {
            this.info.setUseInboundSession(baseInfo.getUseInboundSession());
        }
        if (this.info.getUserName() == null) {
            this.info.setUserName(baseInfo.getUserName());
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return this.adapter;
    }

    public Object createConnectionFactory(ConnectionManager manager) throws ResourceException {
        return new ActiveMQConnectionFactory(this, manager, this.info);
    }

    public Object createConnectionFactory() throws ResourceException {
        return new ActiveMQConnectionFactory(this, new SimpleConnectionManager(), this.info);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        try {
            ActiveMQConnectionRequestInfo amqInfo = (ActiveMQConnectionRequestInfo)info;
            return new ActiveMQManagedConnection(subject, this.adapter.makeConnection(amqInfo), amqInfo);
        }
        catch (JMSException e) {
            throw new ResourceException("Could not create connection.", (Throwable)e);
        }
    }

    public ManagedConnection matchManagedConnections(Set connections, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        Iterator iterator = connections.iterator();
        while (iterator.hasNext()) {
            ActiveMQManagedConnection c = (ActiveMQManagedConnection)iterator.next();
            if (!c.matches(subject, info)) continue;
            try {
                c.associate(subject, (ActiveMQConnectionRequestInfo)info);
                return c;
            }
            catch (JMSException e) {
                throw new ResourceException((Throwable)e);
            }
        }
        return null;
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.logWriter = logWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public String getClientid() {
        return this.info.getClientid();
    }

    public String getPassword() {
        return this.info.getPassword();
    }

    public String getServerUrl() {
        return this.info.getServerUrl();
    }

    public String getUserName() {
        return this.info.getUserName();
    }

    public void setClientid(String clientid) {
        this.info.setClientid(clientid);
    }

    public void setPassword(String password) {
        this.info.setPassword(password);
    }

    public void setServerUrl(String url) {
        this.info.setServerUrl(url);
    }

    public void setUserName(String userid) {
        this.info.setUserName(userid);
    }

    public Boolean getUseInboundSession() {
        return this.info.getUseInboundSession();
    }

    public void setUseInboundSession(Boolean useInboundSession) {
        this.info.setUseInboundSession(useInboundSession);
    }
}

