/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.ra;

import java.net.URI;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.Service;
import org.activemq.broker.BrokerFactory;
import org.activemq.broker.BrokerService;
import org.activemq.ra.ActiveMQActivationSpec;
import org.activemq.ra.ActiveMQConnectionRequestInfo;
import org.activemq.ra.ActiveMQEndpointActivationKey;
import org.activemq.ra.ActiveMQEndpointWorker;
import org.activemq.util.ServiceSupport;

public class ActiveMQResourceAdapter
implements ResourceAdapter {
    private final HashMap endpointWorkers = new HashMap();
    private final ActiveMQConnectionRequestInfo info = new ActiveMQConnectionRequestInfo();
    private BootstrapContext bootstrapContext;
    private String brokerXmlConfig;
    private BrokerService broker;

    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        this.bootstrapContext = bootstrapContext;
        if (this.brokerXmlConfig != null && this.brokerXmlConfig.trim().length() > 0) {
            try {
                this.broker = BrokerFactory.createBroker((URI)new URI(this.brokerXmlConfig));
            }
            catch (Throwable e) {
                throw new ResourceAdapterInternalException("Failed to startup an embedded broker: " + e, e);
            }
        }
    }

    public ActiveMQConnection makeConnection() throws JMSException {
        return this.makeConnection(this.info);
    }

    public ActiveMQConnection makeConnection(ActiveMQConnectionRequestInfo info) throws JMSException {
        ActiveMQConnectionFactory connectionFactory = this.createConnectionFactory(info);
        String userName = info.getUserName();
        String password = info.getPassword();
        ActiveMQConnection physicalConnection = (ActiveMQConnection)connectionFactory.createConnection(userName, password);
        String clientId = info.getClientid();
        if (clientId != null) {
            physicalConnection.setClientID(clientId);
        }
        return physicalConnection;
    }

    public ActiveMQConnection makeConnection(ActiveMQActivationSpec activationSpec) throws JMSException {
        ActiveMQConnectionFactory connectionFactory = this.createConnectionFactory(this.info);
        String userName = this.defaultValue(activationSpec.getUserName(), this.info.getUserName());
        String password = this.defaultValue(activationSpec.getPassword(), this.info.getPassword());
        ActiveMQConnection physicalConnection = (ActiveMQConnection)connectionFactory.createConnection(userName, password);
        if (activationSpec.isDurableSubscription()) {
            physicalConnection.setClientID(activationSpec.getClientId());
        }
        return physicalConnection;
    }

    private synchronized ActiveMQConnectionFactory createConnectionFactory(ActiveMQConnectionRequestInfo info) throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(info.getServerUrl());
        return factory;
    }

    private String defaultValue(String value, String defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void stop() {
        while (this.endpointWorkers.size() > 0) {
            ActiveMQEndpointActivationKey key = (ActiveMQEndpointActivationKey)this.endpointWorkers.keySet().iterator().next();
            this.endpointDeactivation(key.getMessageEndpointFactory(), key.getActivationSpec());
        }
        if (this.broker != null) {
            ServiceSupport.dispose((Service)this.broker);
            this.broker = null;
        }
        this.bootstrapContext = null;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec activationSpec) throws ResourceException {
        ActiveMQEndpointActivationKey key;
        if (activationSpec.getResourceAdapter() != this) {
            throw new ResourceException("Activation spec not initialized with this ResourceAdapter instance");
        }
        if (activationSpec.getClass().equals(ActiveMQActivationSpec.class)) {
            key = new ActiveMQEndpointActivationKey(endpointFactory, (ActiveMQActivationSpec)activationSpec);
            if (this.endpointWorkers.containsKey(key)) {
                throw new IllegalStateException("Endpoint previously activated");
            }
        } else {
            throw new NotSupportedException("That type of ActicationSpec not supported: " + activationSpec.getClass());
        }
        ActiveMQEndpointWorker worker = new ActiveMQEndpointWorker(this, key);
        this.endpointWorkers.put(key, worker);
        worker.start();
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec activationSpec) {
        if (activationSpec.getClass().equals(ActiveMQActivationSpec.class)) {
            ActiveMQEndpointActivationKey key = new ActiveMQEndpointActivationKey(endpointFactory, (ActiveMQActivationSpec)activationSpec);
            ActiveMQEndpointWorker worker = (ActiveMQEndpointWorker)this.endpointWorkers.remove(key);
            if (worker == null) {
                return;
            }
            try {
                worker.stop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecs) throws ResourceException {
        XAResource[] session2;
        ActiveMQConnection connection = null;
        try {
            connection = this.makeConnection();
            if (connection instanceof XAConnection) {
                XASession session2 = ((XAConnection)connection).createXASession();
                XAResource xaResource = session2.getXAResource();
                XAResource[] xAResourceArray = new XAResource[]{xaResource};
                return xAResourceArray;
            }
            session2 = new XAResource[]{};
        }
        catch (JMSException e) {
            throw new ResourceException((Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable ignore) {}
        }
        return session2;
    }

    public String getClientid() {
        return this.emptyToNull(this.info.getClientid());
    }

    public String getPassword() {
        return this.emptyToNull(this.info.getPassword());
    }

    public String getServerUrl() {
        return this.info.getServerUrl();
    }

    public String getUserName() {
        return this.emptyToNull(this.info.getUserName());
    }

    public void setClientid(String clientid) {
        this.info.setClientid(clientid);
    }

    public void setPassword(String password) {
        this.info.setPassword(password);
    }

    public void setServerUrl(String url) {
        this.info.setServerUrl(url);
    }

    public void setUserName(String userid) {
        this.info.setUserName(userid);
    }

    public String getBrokerXmlConfig() {
        return this.brokerXmlConfig;
    }

    public void setBrokerXmlConfig(String brokerXmlConfig) {
        this.brokerXmlConfig = brokerXmlConfig;
    }

    public ActiveMQConnectionRequestInfo getInfo() {
        return this.info;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActiveMQResourceAdapter)) {
            return false;
        }
        ActiveMQResourceAdapter activeMQResourceAdapter = (ActiveMQResourceAdapter)o;
        if (!this.info.equals(activeMQResourceAdapter.info)) {
            return false;
        }
        return !this.notEqual(this.brokerXmlConfig, activeMQResourceAdapter.brokerXmlConfig);
    }

    private boolean notEqual(Object o1, Object o2) {
        return o1 == null ^ o2 == null || o1 != null && !o1.equals(o2);
    }

    public int hashCode() {
        int result = this.info.hashCode();
        if (this.brokerXmlConfig != null) {
            result ^= this.brokerXmlConfig.hashCode();
        }
        return result;
    }

    private String emptyToNull(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    public Boolean getUseInboundSession() {
        return this.info.getUseInboundSession();
    }

    public void setUseInboundSession(Boolean useInboundSession) {
        this.info.setUseInboundSession(useInboundSession);
    }
}

