/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.bdb;

import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BDbHelper {
    private static final Log log = LogFactory.getLog((Class)BDbHelper.class);
    private static ThreadLocal threadLocalTxn = new ThreadLocal();

    public static Environment createEnvironment(File dir) throws DatabaseException {
        dir.mkdirs();
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        return new Environment(dir, envConfig);
    }

    public static DatabaseConfig createDatabaseConfig() {
        DatabaseConfig config = new DatabaseConfig();
        config.setTransactional(true);
        config.setAllowCreate(true);
        return config;
    }

    public static Transaction getTransaction() {
        LinkedList list = (LinkedList)threadLocalTxn.get();
        if (list != null && !list.isEmpty()) {
            return (Transaction)list.getFirst();
        }
        return null;
    }

    public static Transaction popTransaction() {
        LinkedList list = (LinkedList)threadLocalTxn.get();
        if (list == null || list.isEmpty()) {
            log.warn((Object)"Attempt to pop transaction when no transaction in progress");
            return null;
        }
        return (Transaction)list.removeFirst();
    }

    public static void pushTransaction(Transaction transaction) {
        LinkedList<Transaction> list = (LinkedList<Transaction>)threadLocalTxn.get();
        if (list == null) {
            list = new LinkedList<Transaction>();
            threadLocalTxn.set(list);
        }
        list.addLast(transaction);
    }

    public static int getTransactionCount() {
        LinkedList list = (LinkedList)threadLocalTxn.get();
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public static byte[] asBytes(long v) {
        byte[] data = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return data;
    }

    public static byte[] asBytes(Long key) {
        long v = key;
        return BDbHelper.asBytes(v);
    }

    public static long longFromBytes(byte[] data) {
        return ((long)data[0] << 56) + ((long)(data[1] & 0xFF) << 48) + ((long)(data[2] & 0xFF) << 40) + ((long)(data[3] & 0xFF) << 32) + ((long)(data[4] & 0xFF) << 24) + (long)((data[5] & 0xFF) << 16) + (long)((data[6] & 0xFF) << 8) + (long)((data[7] & 0xFF) << 0);
    }
}

