/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.bdb;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.AlreadyClosedException;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.service.MessageContainer;
import org.codehaus.activemq.service.MessageIdentity;
import org.codehaus.activemq.service.QueueMessageContainer;
import org.codehaus.activemq.store.MessageStore;
import org.codehaus.activemq.store.bdb.BDbHelper;
import org.codehaus.activemq.store.bdb.BDbPersistenceAdapter;
import org.codehaus.activemq.store.bdb.SequenceNumberCreator;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class BDbMessageStore
implements MessageStore {
    private static final Log log = LogFactory.getLog((Class)BDbMessageStore.class);
    private Database database;
    private WireFormat wireFormat;
    private SecondaryDatabase secondaryDatabase;
    private SecondaryConfig secondaryConfig;
    private SequenceNumberCreator sequenceNumberCreator;
    private MessageContainer container;
    private CursorConfig cursorConfig;

    public BDbMessageStore(Database database, SecondaryDatabase secondaryDatabase, SecondaryConfig secondaryConfig, SequenceNumberCreator sequenceNumberCreator, WireFormat wireFormat) {
        this.database = database;
        this.secondaryDatabase = secondaryDatabase;
        this.secondaryConfig = secondaryConfig;
        this.sequenceNumberCreator = sequenceNumberCreator;
        this.wireFormat = wireFormat;
    }

    public void setMessageContainer(MessageContainer container) {
        this.container = container;
    }

    public void addMessage(ActiveMQMessage message) throws JMSException {
        this.checkClosed();
        String messageID = message.getJMSMessageID();
        try {
            Transaction transaction = BDbHelper.getTransaction();
            DatabaseEntry key = this.createKey(messageID);
            DatabaseEntry value = new DatabaseEntry(this.asBytes(message));
            this.database.put(transaction, key, value);
            MessageIdentity answer = message.getJMSMessageIdentity();
            answer.setSequenceNumber((Object)this.sequenceNumberCreator.getLastKey());
        }
        catch (DatabaseException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to broker message: " + messageID + " in container: " + (Object)((Object)e)), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to broker message: " + messageID + " in container: " + e), (Exception)e);
        }
    }

    public ActiveMQMessage getMessage(MessageIdentity identity) throws JMSException {
        this.checkClosed();
        ActiveMQMessage answer = null;
        String messageID = identity.getMessageID();
        try {
            DatabaseEntry key = this.createKey(messageID);
            DatabaseEntry value = new DatabaseEntry();
            if (this.database.get(null, key, value, null) == OperationStatus.SUCCESS) {
                answer = this.extractMessage(value);
            }
            return answer;
        }
        catch (DatabaseException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to peek next message after: " + messageID + " from container: " + (Object)((Object)e)), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to broker message: " + messageID + " in container: " + e), (Exception)e);
        }
    }

    public void removeMessage(MessageAck ack) throws JMSException {
        this.checkClosed();
        MessageIdentity identity = ack.getMessageIdentity();
        String messageID = identity.getMessageID();
        try {
            Transaction transaction = BDbHelper.getTransaction();
            DatabaseEntry sequenceNumber = this.getSequenceNumberKey(identity);
            this.sequenceNumberCreator.setDeleteKey(sequenceNumber);
            OperationStatus status = this.secondaryDatabase.delete(transaction, sequenceNumber);
            if (status != OperationStatus.SUCCESS) {
                log.error((Object)("Could not delete sequenece number for: " + identity + " status: " + status));
            }
        }
        catch (DatabaseException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to delete message: " + messageID + " from container: " + (Object)((Object)e)), (Exception)((Object)e));
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void recover(QueueMessageContainer container) throws JMSException {
        SecondaryCursor cursor;
        block8: {
            this.checkClosed();
            cursor = null;
            cursor = this.secondaryDatabase.openSecondaryCursor(BDbHelper.getTransaction(), this.cursorConfig);
            DatabaseEntry sequenceNumberEntry = new DatabaseEntry();
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry valueEntry = new DatabaseEntry();
            OperationStatus status = cursor.getFirst(sequenceNumberEntry, keyEntry, valueEntry, LockMode.DEFAULT);
            while (status == OperationStatus.SUCCESS) {
                String messageID = this.extractString(keyEntry);
                container.recoverMessageToBeDelivered(new MessageIdentity(messageID, (Object)sequenceNumberEntry));
                status = cursor.getNext(sequenceNumberEntry, keyEntry, valueEntry, LockMode.DEFAULT);
            }
            if (status == OperationStatus.NOTFOUND) break block8;
            log.warn((Object)("Unexpected status code while recovering: " + status));
        }
        Object var9_9 = null;
        if (cursor == null) return;
        try {
            cursor.close();
            return;
        }
        catch (DatabaseException e) {
            log.warn((Object)("Caught exception closing cursor: " + (Object)((Object)e)), (Throwable)e);
        }
        return;
        {
            catch (DatabaseException e) {
                throw JMSExceptionHelper.newJMSException((String)("Failed to recover container. Reason: " + (Object)((Object)e)), (Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (cursor == null) throw throwable;
            try {
                cursor.close();
                throw throwable;
            }
            catch (DatabaseException e) {
                log.warn((Object)("Caught exception closing cursor: " + (Object)((Object)e)), (Throwable)e);
            }
            throw throwable;
        }
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
        JMSException firstException = BDbPersistenceAdapter.closeDatabase((Database)this.secondaryDatabase, null);
        firstException = BDbPersistenceAdapter.closeDatabase(this.database, firstException);
        this.secondaryDatabase = null;
        this.database = null;
        if (firstException != null) {
            throw firstException;
        }
    }

    protected SecondaryDatabase getSecondaryDatabase() {
        return this.secondaryDatabase;
    }

    protected Database getDatabase() {
        return this.database;
    }

    public CursorConfig getCursorConfig() {
        return this.cursorConfig;
    }

    public MessageContainer getContainer() {
        return this.container;
    }

    protected void checkClosed() throws AlreadyClosedException {
        if (this.database == null) {
            throw new AlreadyClosedException("Berkeley DB MessageStore");
        }
    }

    protected DatabaseEntry getSequenceNumberKey(MessageIdentity identity) throws DatabaseException {
        DatabaseEntry sequenceNumber = (DatabaseEntry)identity.getSequenceNumber();
        if (sequenceNumber == null) {
            sequenceNumber = this.findSequenceNumber(identity.getMessageID());
        }
        return sequenceNumber;
    }

    protected DatabaseEntry createKey(String messageID) {
        DatabaseEntry key = new DatabaseEntry(this.asBytes(messageID));
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatabaseEntry findSequenceNumber(String messageID) throws DatabaseException {
        DatabaseEntry databaseEntry;
        OperationStatus status;
        DatabaseEntry valueEntry;
        DatabaseEntry keyEntry;
        DatabaseEntry sequenceNumberEntry;
        log.warn((Object)("Having to table scan to find the sequence number for messageID: " + messageID));
        SecondaryCursor cursor = null;
        try {
            cursor = this.secondaryDatabase.openSecondaryCursor(BDbHelper.getTransaction(), this.cursorConfig);
            sequenceNumberEntry = new DatabaseEntry();
            keyEntry = new DatabaseEntry();
            valueEntry = new DatabaseEntry();
            status = cursor.getFirst(sequenceNumberEntry, keyEntry, valueEntry, LockMode.DEFAULT);
            while (status == OperationStatus.SUCCESS) {
                String value = this.extractString(keyEntry);
                if (!messageID.equals(value)) break block10;
                databaseEntry = sequenceNumberEntry;
                Object var10_9 = null;
                if (cursor == null) break block11;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (DatabaseException e) {
                    log.warn((Object)("Caught exception closing cursor: " + (Object)((Object)e)), (Throwable)e);
                }
            }
            throw throwable;
        }
        {
            block10: {
                block11: {
                    try {
                        cursor.close();
                    }
                    catch (DatabaseException e) {
                        log.warn((Object)("Caught exception closing cursor: " + (Object)((Object)e)), (Throwable)e);
                    }
                }
                return databaseEntry;
            }
            status = cursor.getNext(sequenceNumberEntry, keyEntry, valueEntry, LockMode.DEFAULT);
            continue;
        }
        Object var10_10 = null;
        if (cursor != null) {
            try {
                cursor.close();
            }
            catch (DatabaseException e) {
                log.warn((Object)("Caught exception closing cursor: " + (Object)((Object)e)), (Throwable)e);
            }
        }
        return null;
    }

    protected String extractString(DatabaseEntry entry) {
        return new String(entry.getData(), entry.getOffset(), entry.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActiveMQMessage extractMessage(DatabaseEntry value) throws IOException {
        WireFormat wireFormat = this.wireFormat;
        synchronized (wireFormat) {
            return (ActiveMQMessage)this.wireFormat.fromBytes(value.getData(), value.getOffset(), value.getSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] asBytes(ActiveMQMessage message) throws IOException, JMSException {
        WireFormat wireFormat = this.wireFormat;
        synchronized (wireFormat) {
            return this.wireFormat.toBytes((Packet)message);
        }
    }

    protected byte[] asBytes(String messageID) {
        return messageID.getBytes();
    }

    public void removeAllMessages() throws JMSException {
    }
}

