/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.util.Collections;
import java.util.Map;
import javax.xml.bind.ContextFinder;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JAXBContext {
    public static final String JAXB_CONTEXT_FACTORY = "javax.xml.bind.context.factory";

    protected JAXBContext() {
    }

    public static JAXBContext newInstance(String contextPath) throws JAXBException {
        return JAXBContext.newInstance(contextPath, Thread.currentThread().getContextClassLoader());
    }

    public static JAXBContext newInstance(String contextPath, ClassLoader classLoader) throws JAXBException {
        return JAXBContext.newInstance(contextPath, classLoader, Collections.emptyMap());
    }

    public static JAXBContext newInstance(String contextPath, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        return ContextFinder.find(JAXB_CONTEXT_FACTORY, contextPath, classLoader, properties);
    }

    public static JAXBContext newInstance(Class ... classesToBeBound) throws JAXBException {
        return JAXBContext.newInstance(classesToBeBound, Collections.emptyMap());
    }

    public static JAXBContext newInstance(Class[] classesToBeBound, Map<String, ?> properties) throws JAXBException {
        for (int i = classesToBeBound.length - 1; i >= 0; --i) {
            if (classesToBeBound[i] != null) continue;
            throw new IllegalArgumentException();
        }
        return ContextFinder.find(classesToBeBound, properties);
    }

    public abstract Unmarshaller createUnmarshaller() throws JAXBException;

    public abstract Marshaller createMarshaller() throws JAXBException;

    public abstract Validator createValidator() throws JAXBException;

    public JAXBIntrospector createJAXBIntrospector() throws JAXBException {
        throw new UnsupportedOperationException();
    }
}

