/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.annotation;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.annotation.After;
import org.codehaus.aspectwerkz.annotation.AfterFinally;
import org.codehaus.aspectwerkz.annotation.AfterReturning;
import org.codehaus.aspectwerkz.annotation.AfterThrowing;
import org.codehaus.aspectwerkz.annotation.Annotation;
import org.codehaus.aspectwerkz.annotation.AnnotationInfo;
import org.codehaus.aspectwerkz.annotation.AnnotationManager;
import org.codehaus.aspectwerkz.annotation.Around;
import org.codehaus.aspectwerkz.annotation.Aspect;
import org.codehaus.aspectwerkz.annotation.AspectAnnotationParser;
import org.codehaus.aspectwerkz.annotation.Before;
import org.codehaus.aspectwerkz.annotation.Expression;
import org.codehaus.aspectwerkz.annotation.Introduce;
import org.codehaus.aspectwerkz.annotation.Mixin;
import org.codehaus.aspectwerkz.annotation.instrumentation.AttributeEnhancer;
import org.codehaus.aspectwerkz.annotation.instrumentation.asm.AsmAttributeEnhancer;
import org.codehaus.aspectwerkz.exception.DefinitionException;

public class AnnotationC {
    private static final String COMMAND_LINE_OPTION_DASH = "-";
    private static final String COMMAND_LINE_OPTION_VERBOSE = "-verbose";
    private static final String COMMAND_LINE_OPTION_CUSTOM = "-custom";
    private static final String COMMAND_LINE_OPTION_SRC = "-src";
    private static final String COMMAND_LINE_OPTION_SRCFILES = "-srcfiles";
    private static final String COMMAND_LINE_OPTION_SRCINCLUDES = "-srcincludes";
    private static final String COMMAND_LINE_OPTION_CLASSES = "-classes";
    private static final String COMMAND_LINE_OPTION_DEST = "-dest";
    static final String[] SYSTEM_ANNOTATIONS = new String[]{"org.codehaus.aspectwerkz.annotation.Aspect", "org.codehaus.aspectwerkz.annotation.Around", "org.codehaus.aspectwerkz.annotation.Before", "org.codehaus.aspectwerkz.annotation.After", "org.codehaus.aspectwerkz.annotation.AfterFinally", "org.codehaus.aspectwerkz.annotation.AfterReturning", "org.codehaus.aspectwerkz.annotation.AfterThrowing", "org.codehaus.aspectwerkz.annotation.Expression", "org.codehaus.aspectwerkz.annotation.Introduce", "org.codehaus.aspectwerkz.annotation.Mixin"};
    public static final Properties ANNOTATION_DEFINITION = new Properties();
    private static boolean s_verbose = false;
    private static URLClassLoader s_loader;
    private static Map s_customAnnotations;
    private static final String FILE_SEPARATOR;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$annotation$AnnotationC;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$annotation$Aspect;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$annotation$Around;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$annotation$Before;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$annotation$After;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$annotation$AfterReturning;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$annotation$AfterThrowing;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$annotation$AfterFinally;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$annotation$Expression;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$annotation$Introduce;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$annotation$Mixin;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$annotation$UntypedAnnotation;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$joinpoint$JoinPoint;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$joinpoint$StaticJoinPoint;

    public static void main(String[] args) {
        if (args.length < 4) {
            AnnotationC.printUsage();
        }
        Map commandLineOptions = AnnotationC.parseCommandLineOptions(args);
        String propertiesFilesPath = (String)commandLineOptions.get(COMMAND_LINE_OPTION_CUSTOM);
        ArrayList<String> propertiesFilesList = new ArrayList<String>();
        if (propertiesFilesPath != null) {
            StringTokenizer st = new StringTokenizer(propertiesFilesPath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                propertiesFilesList.add(st.nextToken());
            }
        }
        String[] propertiesFiles = propertiesFilesList.toArray(new String[0]);
        AnnotationC.compile((String)commandLineOptions.get(COMMAND_LINE_OPTION_SRC), (String)commandLineOptions.get(COMMAND_LINE_OPTION_SRCFILES), (String)commandLineOptions.get(COMMAND_LINE_OPTION_SRCINCLUDES), (String)commandLineOptions.get(COMMAND_LINE_OPTION_CLASSES), (String)commandLineOptions.get(COMMAND_LINE_OPTION_DEST), propertiesFiles);
    }

    private static void compile(String srcDirList, String srcFileList, String srcFileIncludes, String classPath, String destDir, String[] annotationPropetiesFiles) {
        if (srcDirList == null && srcFileList == null && srcFileIncludes == null) {
            throw new IllegalArgumentException("one of src or srcfiles or srcincludes must be not null");
        }
        if (srcDirList != null && srcFileList != null || srcDirList != null && srcFileIncludes != null || srcFileList != null && srcFileIncludes != null) {
            throw new IllegalArgumentException("maximum one of src, srcfiles or srcincludes must be not null");
        }
        if (classPath == null) {
            throw new IllegalArgumentException("class path can not be null");
        }
        if (destDir == null) {
            destDir = classPath;
        }
        String[] srcDirs = new String[]{};
        String[] srcFiles = new String[]{};
        if (srcDirList != null) {
            srcDirs = AnnotationC.split(srcDirList, File.pathSeparator);
        } else {
            srcFiles = srcFileList != null ? AnnotationC.split(srcFileList, FILE_SEPARATOR) : AnnotationC.loadSourceList(srcFileIncludes);
        }
        AnnotationC.compile(s_verbose, srcDirs, srcFiles, AnnotationC.split(classPath, File.pathSeparator), destDir, annotationPropetiesFiles);
    }

    public static void compile(boolean verbose, String[] srcDirs, String[] srcFiles, String[] classpath, String destDir, String[] annotationPropertiesFiles) {
        int i;
        s_verbose = verbose;
        URL[] classPath = new URL[classpath.length];
        try {
            for (int i2 = 0; i2 < classpath.length; ++i2) {
                classPath[i2] = new File(classpath[i2]).toURL();
            }
            s_loader = new URLClassLoader(classPath, (class$org$codehaus$aspectwerkz$annotation$AnnotationC == null ? (class$org$codehaus$aspectwerkz$annotation$AnnotationC = AnnotationC.class$("org.codehaus.aspectwerkz.annotation.AnnotationC")) : class$org$codehaus$aspectwerkz$annotation$AnnotationC).getClassLoader());
        }
        catch (MalformedURLException e) {
            String message = "URL [" + classPath + "] is not valid: " + e.toString();
            AnnotationC.logError(message);
            throw new DefinitionException(message, e);
        }
        String destDirToUse = destDir;
        if (destDir == null) {
            if (classpath.length != 1) {
                throw new DefinitionException("destDir must be specified since classpath is composite");
            }
            destDirToUse = classpath[0];
        }
        AnnotationManager manager = new AnnotationManager(s_loader);
        AnnotationC.logInfo("parsing source dirs:");
        for (i = 0; i < srcDirs.length; ++i) {
            AnnotationC.logInfo("    " + srcDirs[i]);
        }
        manager.addSourceTrees(srcDirs);
        for (i = 0; i < srcFiles.length; ++i) {
            AnnotationC.logInfo("    " + srcFiles[i]);
            manager.addSource(srcFiles[i]);
        }
        AnnotationC.doCompile(annotationPropertiesFiles, classPath, manager, destDirToUse);
    }

    private static void doCompile(String[] annotationPropetiesFiles, URL[] classPath, AnnotationManager manager, String destDir) {
        AnnotationC.logInfo("compiling annotations...");
        AnnotationC.logInfo("note: if no output is seen, then nothing is compiled");
        AnnotationC.registerSystemAnnotations(manager);
        AnnotationC.registerUserDefinedAnnotations(manager, annotationPropetiesFiles);
        JavaClass[] classes = manager.getAllClasses();
        for (int i = 0; i < classes.length; ++i) {
            JavaClass clazz = classes[i];
            AnnotationC.logInfo("class [" + clazz.getFullyQualifiedName() + ']');
            try {
                AsmAttributeEnhancer enhancer = new AsmAttributeEnhancer();
                if (!enhancer.initialize(clazz.getFullyQualifiedName(), classPath)) continue;
                AnnotationC.handleClassAnnotations(manager, enhancer, clazz);
                AnnotationC.handleInnerClassAnnotations(manager, enhancer, clazz);
                JavaMethod[] methods = clazz.getMethods();
                for (int j = 0; j < methods.length; ++j) {
                    JavaMethod method = methods[j];
                    if (method.isConstructor()) {
                        AnnotationC.handleConstructorAnnotations(manager, enhancer, method);
                        continue;
                    }
                    AnnotationC.handleMethodAnnotations(manager, enhancer, method);
                }
                JavaField[] fields = clazz.getFields();
                for (int j = 0; j < fields.length; ++j) {
                    AnnotationC.handleFieldAnnotations(manager, enhancer, fields[j]);
                }
                enhancer.write(destDir);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                AnnotationC.logWarning("could not compile annotations for class [" + clazz.getFullyQualifiedName() + "] due to: " + e.toString());
            }
        }
        AnnotationC.logInfo("compiled classes written to " + destDir);
        AnnotationC.logInfo("compilation successful");
    }

    private static void handleClassAnnotations(AnnotationManager manager, AttributeEnhancer enhancer, JavaClass clazz) {
        AnnotationC.parseCustomClassAnnotations(clazz, manager, enhancer);
        AnnotationC.parseAspectAnnotations(clazz, manager, enhancer);
        AnnotationC.parseMixinAnnotations(clazz, manager, enhancer);
    }

    private static void parseCustomClassAnnotations(JavaClass clazz, AnnotationManager manager, AttributeEnhancer enhancer) {
        Iterator it = s_customAnnotations.keySet().iterator();
        while (it.hasNext()) {
            String annotationName = (String)it.next();
            Annotation[] customAnnotations = manager.getAnnotations(annotationName, clazz);
            for (int i = 0; i < customAnnotations.length; ++i) {
                Annotation customAnnotation = customAnnotations[i];
                if (customAnnotation == null) continue;
                enhancer.insertClassAttribute(new AnnotationInfo(annotationName, customAnnotation));
                AnnotationC.logInfo("    custom class annotation [" + annotationName + " @ " + clazz.getFullyQualifiedName() + ']');
            }
        }
    }

    private static void parseAspectAnnotations(JavaClass clazz, AnnotationManager manager, AttributeEnhancer enhancer) {
        Annotation[] annotations = manager.getAnnotations("org.codehaus.aspectwerkz.annotation.Aspect", clazz);
        for (int i = 0; i < annotations.length; ++i) {
            Annotation annotation = annotations[i];
            if (annotation == null) continue;
            enhancer.insertClassAttribute(new AnnotationInfo("org.codehaus.aspectwerkz.annotation.Aspect", annotation));
            String name = ((Aspect)((Object)annotation)).name();
            if (name == null) {
                name = clazz.getFullyQualifiedName();
            }
            String deploymentModel = ((Aspect)((Object)annotation)).deploymentModel();
            if (((Aspect)((Object)annotation)).value() != null) {
                deploymentModel = ((Aspect)((Object)annotation)).value();
            }
            AnnotationC.logInfo("aspect [" + name + ']');
            AnnotationC.logInfo("    deployment model [" + deploymentModel + ']');
        }
    }

    private static void parseMixinAnnotations(JavaClass clazz, AnnotationManager manager, AttributeEnhancer enhancer) {
        Annotation[] introduceAnnotations = manager.getAnnotations("Mixin", clazz);
        String className = clazz.getFullyQualifiedName();
        for (int k = 0; k < introduceAnnotations.length; ++k) {
            String expression;
            int j;
            Annotation introduceAnnotation = introduceAnnotations[k];
            if (introduceAnnotation == null || !(introduceAnnotation instanceof Mixin)) continue;
            JavaClass[] introducedInterfaceClasses = clazz.getImplementedInterfaces();
            String[] introducedInterfaceNames = new String[introducedInterfaceClasses.length];
            for (j = 0; j < introducedInterfaceClasses.length; ++j) {
                introducedInterfaceNames[j] = introducedInterfaceClasses[j].getFullyQualifiedName();
                AnnotationC.logInfo("    interface introduction [" + introducedInterfaceNames[j] + ']');
            }
            if (introducedInterfaceNames.length == 0) {
                introducedInterfaceNames = enhancer.getNearestInterfacesInHierarchy(className);
                if (introducedInterfaceNames.length == 0) {
                    throw new RuntimeException("no implicit interfaces found for " + className);
                }
                for (j = 0; j < introducedInterfaceNames.length; ++j) {
                    AnnotationC.logInfo("    interface introduction [" + introducedInterfaceNames[j] + ']');
                }
            }
            String deploymentModel = DeploymentModel.PER_JVM.toString();
            if (((Mixin)((Object)introduceAnnotation)).deploymentModel() != null) {
                deploymentModel = ((Mixin)((Object)introduceAnnotation)).deploymentModel();
            }
            if ((expression = ((Mixin)((Object)introduceAnnotation)).pointcut()) == null) {
                expression = ((Mixin)((Object)introduceAnnotation)).value();
            }
            AnnotationC.logInfo("    mixin introduction [" + clazz.getFullyQualifiedName() + " :: " + expression + "] deployment model [" + deploymentModel + ']');
            enhancer.insertClassAttribute(new AnnotationInfo("org.codehaus.aspectwerkz.annotation.Mixin", introduceAnnotation));
        }
    }

    private static void handleMethodAnnotations(AnnotationManager manager, AttributeEnhancer enhancer, JavaMethod method) {
        Annotation[] expressionAnnotations = manager.getAnnotations("Expression", method);
        for (int i = 0; i < expressionAnnotations.length; ++i) {
            Annotation expressionAnnotation = expressionAnnotations[i];
            if (expressionAnnotation == null || !(expressionAnnotation instanceof Expression)) continue;
            enhancer.insertMethodAttribute(method, new AnnotationInfo("org.codehaus.aspectwerkz.annotation.Expression", expressionAnnotation));
            AnnotationC.logInfo("    pointcut [" + AnnotationC.getShortCallSignature(method) + " :: " + ((Expression)((Object)expressionAnnotation)).value() + ']');
        }
        Annotation[] aroundAnnotations = manager.getAnnotations("Around", method);
        for (int i = 0; i < aroundAnnotations.length; ++i) {
            Annotation aroundAnnotation = aroundAnnotations[i];
            if (aroundAnnotation == null || !(aroundAnnotation instanceof Around)) continue;
            enhancer.insertMethodAttribute(method, new AnnotationInfo("org.codehaus.aspectwerkz.annotation.Around", aroundAnnotation));
            AnnotationC.logInfo("    around advice [" + AnnotationC.getShortCallSignature(method) + " :: " + ((Around)((Object)aroundAnnotation)).value() + ']');
        }
        Annotation[] beforeAnnotations = manager.getAnnotations("Before", method);
        for (int i = 0; i < beforeAnnotations.length; ++i) {
            Annotation beforeAnnotation = beforeAnnotations[i];
            if (beforeAnnotation == null || !(beforeAnnotation instanceof Before)) continue;
            enhancer.insertMethodAttribute(method, new AnnotationInfo("org.codehaus.aspectwerkz.annotation.Before", beforeAnnotation));
            AnnotationC.logInfo("    before [" + AnnotationC.getShortCallSignature(method) + " :: " + ((Before)((Object)beforeAnnotation)).value() + ']');
        }
        Annotation[] afterAnnotations = manager.getAnnotations("After", method);
        for (int i = 0; i < afterAnnotations.length; ++i) {
            Annotation afterAnnotation = afterAnnotations[i];
            if (afterAnnotation == null || !(afterAnnotation instanceof After)) continue;
            enhancer.insertMethodAttribute(method, new AnnotationInfo("org.codehaus.aspectwerkz.annotation.After", afterAnnotation));
            AnnotationC.logInfo("    after advice [" + AnnotationC.getShortCallSignature(method) + " :: " + ((After)((Object)afterAnnotation)).value() + ']');
        }
        Annotation[] afterFinallyAnnotations = manager.getAnnotations("AfterFinally", method);
        for (int i = 0; i < afterFinallyAnnotations.length; ++i) {
            Annotation afterAnnotation = afterFinallyAnnotations[i];
            if (afterAnnotation == null || !(afterAnnotation instanceof AfterFinally)) continue;
            enhancer.insertMethodAttribute(method, new AnnotationInfo("org.codehaus.aspectwerkz.annotation.AfterFinally", afterAnnotation));
            AnnotationC.logInfo("    after finally advice [" + AnnotationC.getShortCallSignature(method) + " :: " + ((AfterFinally)((Object)afterAnnotation)).value() + ']');
        }
        Annotation[] afterReturningAnnotations = manager.getAnnotations("AfterReturning", method);
        for (int i = 0; i < afterReturningAnnotations.length; ++i) {
            Annotation afterAnnotation = afterReturningAnnotations[i];
            if (afterAnnotation == null || !(afterAnnotation instanceof AfterReturning)) continue;
            enhancer.insertMethodAttribute(method, new AnnotationInfo("org.codehaus.aspectwerkz.annotation.AfterReturning", afterAnnotation));
            AnnotationC.logInfo("    after returning advice [" + AnnotationC.getShortCallSignature(method) + " :: " + AspectAnnotationParser.getExpressionElseValue(((AfterReturning)((Object)afterAnnotation)).value(), ((AfterReturning)((Object)afterAnnotation)).pointcut()) + " :: " + ((AfterReturning)((Object)afterAnnotation)).type() + ']');
        }
        Annotation[] afterThrowingAnnotations = manager.getAnnotations("AfterThrowing", method);
        for (int i = 0; i < afterThrowingAnnotations.length; ++i) {
            Annotation afterAnnotation = afterThrowingAnnotations[i];
            if (afterAnnotation == null || !(afterAnnotation instanceof AfterThrowing)) continue;
            enhancer.insertMethodAttribute(method, new AnnotationInfo("org.codehaus.aspectwerkz.annotation.AfterThrowing", afterAnnotation));
            AnnotationC.logInfo("    after throwing advice [" + AnnotationC.getShortCallSignature(method) + " :: " + AspectAnnotationParser.getExpressionElseValue(((AfterThrowing)((Object)afterAnnotation)).value(), ((AfterThrowing)((Object)afterAnnotation)).pointcut()) + " :: " + ((AfterThrowing)((Object)afterAnnotation)).type() + ']');
        }
        Iterator it = s_customAnnotations.keySet().iterator();
        while (it.hasNext()) {
            String annotationName = (String)it.next();
            Annotation[] customAnnotations = manager.getAnnotations(annotationName, method);
            for (int i = 0; i < customAnnotations.length; ++i) {
                Annotation customAnnotation = customAnnotations[i];
                if (customAnnotation == null) continue;
                enhancer.insertMethodAttribute(method, new AnnotationInfo(annotationName, customAnnotation));
                AnnotationC.logInfo("    custom method annotation [" + annotationName + " @ " + method.getParentClass().getName() + '.' + method.getName() + ']');
            }
        }
    }

    private static void handleConstructorAnnotations(AnnotationManager manager, AttributeEnhancer enhancer, JavaMethod constructor) {
        Iterator it = s_customAnnotations.keySet().iterator();
        while (it.hasNext()) {
            String annotationName = (String)it.next();
            Annotation[] customAnnotations = manager.getAnnotations(annotationName, constructor);
            for (int i = 0; i < customAnnotations.length; ++i) {
                Annotation customAnnotation = customAnnotations[i];
                if (customAnnotation == null) continue;
                enhancer.insertConstructorAttribute(constructor, new AnnotationInfo(annotationName, customAnnotation));
                AnnotationC.logInfo("    custom constructor annotation [" + annotationName + " @ " + constructor.getParentClass().getName() + '.' + constructor.getName() + ']');
            }
        }
    }

    private static void handleFieldAnnotations(AnnotationManager manager, AttributeEnhancer enhancer, JavaField field) {
        Annotation[] expressionAnnotations = manager.getAnnotations("Expression", field);
        for (int i = 0; i < expressionAnnotations.length; ++i) {
            Annotation expressionAnnotation = expressionAnnotations[i];
            if (expressionAnnotation == null || !(expressionAnnotation instanceof Expression)) continue;
            enhancer.insertFieldAttribute(field, new AnnotationInfo("org.codehaus.aspectwerkz.annotation.Expression", expressionAnnotation));
            AnnotationC.logInfo("    pointcut [" + field.getName() + " :: " + ((Expression)((Object)expressionAnnotation)).value() + ']');
        }
        Annotation[] introduceAnnotations = manager.getAnnotations("Introduce", field);
        for (int i = 0; i < introduceAnnotations.length; ++i) {
            Annotation introduceAnnotation = introduceAnnotations[i];
            if (introduceAnnotation == null || !(introduceAnnotation instanceof Introduce)) continue;
            enhancer.insertFieldAttribute(field, new AnnotationInfo("org.codehaus.aspectwerkz.annotation.Introduce", introduceAnnotation));
            AnnotationC.logInfo("    interface introduction [" + field.getName() + " :: " + ((Introduce)((Object)introduceAnnotation)).value() + ']');
        }
        Iterator it = s_customAnnotations.keySet().iterator();
        while (it.hasNext()) {
            String annotationName = (String)it.next();
            Annotation[] customAnnotations = manager.getAnnotations(annotationName, field);
            for (int i = 0; i < customAnnotations.length; ++i) {
                Annotation customAnnotation = customAnnotations[i];
                if (customAnnotation == null) continue;
                enhancer.insertFieldAttribute(field, new AnnotationInfo(annotationName, customAnnotation));
                AnnotationC.logInfo("    custom field annotation [" + annotationName + " @ " + field.getName() + ']');
            }
        }
    }

    private static void handleInnerClassAnnotations(AnnotationManager manager, AttributeEnhancer enhancer, JavaClass clazz) {
        JavaClass[] innerClasses = clazz.getInnerClasses();
        for (int i = 0; i < innerClasses.length; ++i) {
            AnnotationC.parseMixinAnnotations(innerClasses[i], manager, enhancer);
        }
    }

    private static void registerSystemAnnotations(AnnotationManager manager) {
        manager.registerAnnotationProxy(class$org$codehaus$aspectwerkz$annotation$Aspect == null ? (class$org$codehaus$aspectwerkz$annotation$Aspect = AnnotationC.class$("org.codehaus.aspectwerkz.annotation.Aspect")) : class$org$codehaus$aspectwerkz$annotation$Aspect, "Aspect");
        manager.registerAnnotationProxy(class$org$codehaus$aspectwerkz$annotation$Around == null ? (class$org$codehaus$aspectwerkz$annotation$Around = AnnotationC.class$("org.codehaus.aspectwerkz.annotation.Around")) : class$org$codehaus$aspectwerkz$annotation$Around, "Around");
        manager.registerAnnotationProxy(class$org$codehaus$aspectwerkz$annotation$Before == null ? (class$org$codehaus$aspectwerkz$annotation$Before = AnnotationC.class$("org.codehaus.aspectwerkz.annotation.Before")) : class$org$codehaus$aspectwerkz$annotation$Before, "Before");
        manager.registerAnnotationProxy(class$org$codehaus$aspectwerkz$annotation$After == null ? (class$org$codehaus$aspectwerkz$annotation$After = AnnotationC.class$("org.codehaus.aspectwerkz.annotation.After")) : class$org$codehaus$aspectwerkz$annotation$After, "After");
        manager.registerAnnotationProxy(class$org$codehaus$aspectwerkz$annotation$AfterReturning == null ? (class$org$codehaus$aspectwerkz$annotation$AfterReturning = AnnotationC.class$("org.codehaus.aspectwerkz.annotation.AfterReturning")) : class$org$codehaus$aspectwerkz$annotation$AfterReturning, "AfterReturning");
        manager.registerAnnotationProxy(class$org$codehaus$aspectwerkz$annotation$AfterThrowing == null ? (class$org$codehaus$aspectwerkz$annotation$AfterThrowing = AnnotationC.class$("org.codehaus.aspectwerkz.annotation.AfterThrowing")) : class$org$codehaus$aspectwerkz$annotation$AfterThrowing, "AfterThrowing");
        manager.registerAnnotationProxy(class$org$codehaus$aspectwerkz$annotation$AfterFinally == null ? (class$org$codehaus$aspectwerkz$annotation$AfterFinally = AnnotationC.class$("org.codehaus.aspectwerkz.annotation.AfterFinally")) : class$org$codehaus$aspectwerkz$annotation$AfterFinally, "AfterFinally");
        manager.registerAnnotationProxy(class$org$codehaus$aspectwerkz$annotation$Expression == null ? (class$org$codehaus$aspectwerkz$annotation$Expression = AnnotationC.class$("org.codehaus.aspectwerkz.annotation.Expression")) : class$org$codehaus$aspectwerkz$annotation$Expression, "Expression");
        manager.registerAnnotationProxy(class$org$codehaus$aspectwerkz$annotation$Introduce == null ? (class$org$codehaus$aspectwerkz$annotation$Introduce = AnnotationC.class$("org.codehaus.aspectwerkz.annotation.Introduce")) : class$org$codehaus$aspectwerkz$annotation$Introduce, "Introduce");
        manager.registerAnnotationProxy(class$org$codehaus$aspectwerkz$annotation$Mixin == null ? (class$org$codehaus$aspectwerkz$annotation$Mixin = AnnotationC.class$("org.codehaus.aspectwerkz.annotation.Mixin")) : class$org$codehaus$aspectwerkz$annotation$Mixin, "Mixin");
    }

    /*
     * WARNING - void declaration
     */
    private static void registerUserDefinedAnnotations(AnnotationManager manager, String[] propertiesFiles) {
        if (propertiesFiles == null) {
            return;
        }
        FileInputStream in = null;
        for (int i = 0; i < propertiesFiles.length; ++i) {
            String propertiesFile = propertiesFiles[i];
            try {
                in = new FileInputStream(propertiesFile);
                ANNOTATION_DEFINITION.load(in);
                continue;
            }
            catch (Exception e) {
                String message = "custom annotation properties " + propertiesFile + " can not be loaded: " + e.toString();
                AnnotationC.logWarning(message);
                throw new DefinitionException(message);
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {}
            }
        }
        Iterator<Map.Entry<Object, Object>> it = ANNOTATION_DEFINITION.entrySet().iterator();
        while (it.hasNext()) {
            void var7_12;
            Class<?> klass;
            Map.Entry<Object, Object> entry = it.next();
            String name = ((String)entry.getKey()).trim();
            String className = ((String)entry.getValue()).trim();
            if (className.equals("")) {
                klass = class$org$codehaus$aspectwerkz$annotation$UntypedAnnotation == null ? AnnotationC.class$("org.codehaus.aspectwerkz.annotation.UntypedAnnotation") : class$org$codehaus$aspectwerkz$annotation$UntypedAnnotation;
                className = klass.getName();
            } else {
                try {
                    klass = Class.forName(className, false, s_loader);
                }
                catch (ClassNotFoundException e) {
                    String message = className + " could not be found on system classpath or class path provided as argument to the compiler";
                    AnnotationC.logError(message);
                    throw new DefinitionException(message);
                }
            }
            AnnotationC.logInfo("register custom annotation [" + name + " :: " + className + ']');
            manager.registerAnnotationProxy((Class)var7_12, name);
            s_customAnnotations.put(name, className);
        }
    }

    private static void printUsage() {
        System.out.println("AspectWerkz (c) 2002-2005 Jonas Bon\u017dr, Alexandre Vasseur");
        System.out.println("usage: java [options...] org.codehaus.aspectwerkz.annotation.AnnotationC [-verbose] -src <path to src dir> | -srcfiles <list of files> | -srcincludes <path to file> -classes <path to classes dir> [-dest <path to destination dir>] [-custom <property file for custom annotations>]");
        System.out.println("       -src <path to src dir> provides the list of source directories separated by File.pathSeparator");
        System.out.println("       -srcpath <list of files> provides a comma separated list of source files");
        System.out.println("       -srcincludes <path to file> provides the path to a file containing the list of source files (one name per line)");
        System.out.println("       -dest <path to destination dir> is optional, if omitted the compiled classes will be written to the initial directory");
        System.out.println("       -custom <property file for cutom annotations> is optional, only needed if you have custom annotations you want to compile");
        System.out.println("       -verbose activates compilation status information");
        System.out.println("");
        System.out.println("Note: only one of -src -srcpath and -srcincludes may be used");
        System.exit(0);
    }

    private static Map parseCommandLineOptions(String[] args) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(COMMAND_LINE_OPTION_VERBOSE)) {
                    s_verbose = true;
                    continue;
                }
                if (!args[i].startsWith(COMMAND_LINE_OPTION_DASH)) continue;
                String option = args[i++];
                String value = args[i];
                arguments.put(option, value);
            }
        }
        catch (Exception e) {
            AnnotationC.logError("options list to compiler is not valid");
            System.exit(1);
        }
        return arguments;
    }

    private static void logInfo(String message) {
        if (s_verbose) {
            System.out.println("AnnotationC::INFO - " + message);
        }
    }

    private static void logError(String message) {
        if (s_verbose) {
            System.err.println("AnnotationC::ERROR - " + message);
        }
    }

    private static void logWarning(String message) {
        if (s_verbose) {
            System.err.println("AnnotationC::WARNING - " + message);
        }
    }

    private static String getShortCallSignature(JavaMethod method) {
        StringBuffer buffer = new StringBuffer(method.getName());
        buffer.append("(");
        for (int i = 0; i < method.getParameters().length; ++i) {
            JavaParameter javaParameter = method.getParameters()[i];
            if (javaParameter.getType().toString().equals((class$org$codehaus$aspectwerkz$joinpoint$JoinPoint == null ? AnnotationC.class$("org.codehaus.aspectwerkz.joinpoint.JoinPoint") : class$org$codehaus$aspectwerkz$joinpoint$JoinPoint).getName())) {
                buffer.append("JoinPoint");
            } else if (javaParameter.getType().toString().equals((class$org$codehaus$aspectwerkz$joinpoint$StaticJoinPoint == null ? AnnotationC.class$("org.codehaus.aspectwerkz.joinpoint.StaticJoinPoint") : class$org$codehaus$aspectwerkz$joinpoint$StaticJoinPoint).getName())) {
                buffer.append("StaticJoinPoint");
            } else {
                buffer.append(javaParameter.getType().toString());
                buffer.append(" ");
                buffer.append(javaParameter.getName());
            }
            if (i + 1 >= method.getParameters().length) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    private static String[] split(String str, String sep) {
        if (str == null || str.length() == 0) {
            return new String[0];
        }
        int start = 0;
        int idx = str.indexOf(sep, start);
        int len = sep.length();
        ArrayList<String> strings = new ArrayList<String>();
        while (idx != -1) {
            strings.add(str.substring(start, idx));
            start = idx + len;
            idx = str.indexOf(sep, start);
        }
        strings.add(str.substring(start));
        return strings.toArray(new String[strings.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] loadSourceList(String srcIncludes) {
        File currentDir = new File(".");
        ArrayList<String> files = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(srcIncludes));
                String line = reader.readLine();
                File tmpFile = null;
                while (line != null) {
                    if (line.length() > 0) {
                        tmpFile = new File(currentDir, line);
                        if (!tmpFile.isFile()) {
                            AnnotationC.logWarning("file not found: [" + tmpFile + "]");
                        } else {
                            files.add(tmpFile.getAbsolutePath());
                        }
                    }
                    line = reader.readLine();
                }
                Object var7_7 = null;
                if (null == reader) return files.toArray(new String[files.size()]);
            }
            catch (IOException ioe) {
                throw new BuildException("an error occured while reading from pattern file: " + srcIncludes, (Throwable)ioe);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (null == reader) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        reader.close();
        return files.toArray(new String[files.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_customAnnotations = new HashMap();
        FILE_SEPARATOR = File.separator;
    }
}

