/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.aspect;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.AspectContext;
import org.codehaus.aspectwerkz.aspect.AspectContainer;

public abstract class AbstractAspectContainer
implements AspectContainer {
    public static final int ASPECT_CONSTRUCTION_TYPE_UNKNOWN = 0;
    public static final int ASPECT_CONSTRUCTION_TYPE_DEFAULT = 1;
    public static final int ASPECT_CONSTRUCTION_TYPE_ASPECT_CONTEXT = 2;
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected final Object[] ARRAY_WITH_SINGLE_ASPECT_CONTEXT = new Object[1];
    protected int m_constructionType = 0;
    protected final AspectContext m_aspectContext;
    protected Object m_perJvm;
    protected final Map m_perClass = new WeakHashMap();
    protected final Map m_perInstance = new WeakHashMap();
    protected final Map m_perThread = new WeakHashMap();
    protected final Map m_adviceInfos = new HashMap();

    public AbstractAspectContainer(AspectContext aspectContext) {
        if (aspectContext == null) {
            throw new IllegalArgumentException("cross-cutting info can not be null");
        }
        this.m_aspectContext = aspectContext;
        this.ARRAY_WITH_SINGLE_ASPECT_CONTEXT[0] = this.m_aspectContext;
    }

    public AspectContext getContext() {
        return this.m_aspectContext;
    }

    public Object aspectOf() {
        if (this.m_perJvm == null) {
            this.m_perJvm = this.createAspect();
        }
        return this.m_perJvm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object aspectOf(Class klass) {
        Map map = this.m_perClass;
        synchronized (map) {
            if (!this.m_perClass.containsKey(klass)) {
                this.m_perClass.put(klass, this.createAspect());
            }
        }
        return this.m_perClass.get(klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object aspectOf(Object instance) {
        Map map = this.m_perInstance;
        synchronized (map) {
            if (!this.m_perInstance.containsKey(instance)) {
                this.m_perInstance.put(instance, this.createAspect());
            }
        }
        return this.m_perInstance.get(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object aspectOf(Thread thread) {
        Map map = this.m_perThread;
        synchronized (map) {
            if (!this.m_perThread.containsKey(thread)) {
                this.m_perThread.put(thread, this.createAspect());
            }
        }
        return this.m_perThread.get(thread);
    }

    protected abstract Object createAspect();
}

