/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.connectivity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.codehaus.aspectwerkz.connectivity.Invoker;
import org.codehaus.aspectwerkz.connectivity.RemoteProxy;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;

public class RemoteProxyServerThread
implements Runnable {
    private final Socket m_socket;
    private ObjectInputStream m_in = null;
    private ObjectOutputStream m_out = null;
    private ClassLoader m_loader = null;
    private Invoker m_invoker = null;
    private int m_timeout = 60000;
    private boolean m_running = true;

    public RemoteProxyServerThread(Socket clientSocket, ClassLoader loader, Invoker invoker, int timeout) {
        if (clientSocket == null) {
            throw new IllegalArgumentException("client socket can not be null");
        }
        this.m_socket = clientSocket;
        this.m_loader = loader;
        this.m_invoker = invoker;
        this.m_timeout = timeout;
    }

    public void run() {
        Thread.currentThread().setContextClassLoader(this.m_loader);
        try {
            this.m_socket.setTcpNoDelay(true);
            this.m_socket.setSoTimeout(this.m_timeout);
            this.m_in = new ObjectInputStream(this.m_socket.getInputStream());
            this.m_out = new ObjectOutputStream(this.m_socket.getOutputStream());
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(e);
        }
        while (this.m_running) {
            try {
                switch (this.m_in.read()) {
                    case 0: {
                        this.handleCreateCommand();
                        break;
                    }
                    case 1: {
                        this.handleInvocationCommand();
                        break;
                    }
                    case 2: {
                        this.m_running = false;
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.close();
                throw new WrappedRuntimeException(e);
            }
        }
        this.close();
    }

    private void handleCreateCommand() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String className = (String)this.m_in.readObject();
        Class<?> klass = Class.forName(className, false, this.m_loader);
        Object instance = klass.newInstance();
        String handle = RemoteProxy.wrapInstance(instance);
        this.m_out.writeObject(handle);
        this.m_out.flush();
    }

    private void handleInvocationCommand() throws IOException, ClassNotFoundException {
        Object context = this.m_in.readObject();
        String handle = (String)this.m_in.readObject();
        String methodName = (String)this.m_in.readObject();
        Class[] paramTypes = (Class[])this.m_in.readObject();
        Object[] args = (Object[])this.m_in.readObject();
        Object result = null;
        try {
            result = this.m_invoker.invoke(handle, methodName, paramTypes, args, context);
        }
        catch (Exception e) {
            result = e;
        }
        this.m_out.writeObject(result);
        this.m_out.flush();
    }

    private void close() {
        try {
            if (this.m_in != null) {
                this.m_in.close();
            }
            if (this.m_out != null) {
                this.m_out.close();
            }
            if (this.m_socket != null) {
                this.m_socket.close();
            }
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(e);
        }
    }
}

