/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.expression.ast;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.aspectwerkz.expression.SubtypePatternType;
import org.codehaus.aspectwerkz.expression.ast.ExpressionParser;
import org.codehaus.aspectwerkz.expression.ast.ExpressionParserVisitor;
import org.codehaus.aspectwerkz.expression.ast.ParseException;
import org.codehaus.aspectwerkz.expression.ast.SimpleNode;
import org.codehaus.aspectwerkz.expression.regexp.NamePattern;
import org.codehaus.aspectwerkz.expression.regexp.Pattern;
import org.codehaus.aspectwerkz.expression.regexp.TypePattern;

public class ASTMethodPattern
extends SimpleNode {
    private TypePattern m_returnTypePattern;
    private TypePattern m_declaringTypePattern;
    private NamePattern m_methodNamePattern;
    private List m_modifiers = new ArrayList();

    public ASTMethodPattern(int id) {
        super(id);
    }

    public ASTMethodPattern(ExpressionParser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ExpressionParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void addModifier(String modifier) {
        this.m_modifiers.add(modifier);
    }

    public void setReturnTypePattern(String pattern) {
        if (pattern.endsWith("+")) {
            pattern = pattern.substring(0, pattern.length() - 1);
            this.m_returnTypePattern = Pattern.compileTypePattern(pattern, SubtypePatternType.MATCH_ON_ALL_METHODS);
        } else if (pattern.endsWith("#")) {
            pattern = pattern.substring(0, pattern.length() - 1);
            this.m_returnTypePattern = Pattern.compileTypePattern(pattern, SubtypePatternType.MATCH_ON_BASE_TYPE_METHODS_ONLY);
        } else {
            this.m_returnTypePattern = Pattern.compileTypePattern(pattern, SubtypePatternType.NOT_HIERARCHICAL);
        }
    }

    public void setFullNamePattern(String pattern) throws ParseException {
        int index = pattern.lastIndexOf(46);
        String classPattern = null;
        if (index > 0) {
            classPattern = pattern.substring(0, index);
            if (classPattern.endsWith(".")) {
                classPattern = classPattern + ".*";
            }
        } else {
            classPattern = "*..*";
        }
        if (classPattern.endsWith("+")) {
            classPattern = classPattern.substring(0, classPattern.length() - 1);
            this.m_declaringTypePattern = Pattern.compileTypePattern(classPattern, SubtypePatternType.MATCH_ON_ALL_METHODS);
        } else if (classPattern.endsWith("#")) {
            classPattern = classPattern.substring(0, classPattern.length() - 1);
            this.m_declaringTypePattern = Pattern.compileTypePattern(classPattern, SubtypePatternType.MATCH_ON_BASE_TYPE_METHODS_ONLY);
        } else {
            this.m_declaringTypePattern = Pattern.compileTypePattern(classPattern, SubtypePatternType.NOT_HIERARCHICAL);
        }
        String methodNamePattern = pattern.substring(index + 1, pattern.length());
        this.m_methodNamePattern = Pattern.compileNamePattern(methodNamePattern);
        if ("new".equals(methodNamePattern)) {
            throw new ParseException("Using a constructor pattern with an explicit return type is not allowed");
        }
    }

    public TypePattern getReturnTypePattern() {
        return this.m_returnTypePattern;
    }

    public TypePattern getDeclaringTypePattern() {
        return this.m_declaringTypePattern;
    }

    public NamePattern getMethodNamePattern() {
        return this.m_methodNamePattern;
    }

    public List getModifiers() {
        return this.m_modifiers;
    }
}

