/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.joinpoint.impl;

import java.io.Serializable;
import java.lang.reflect.Method;

public class MethodTuple
implements Serializable {
    private final Method m_wrapperMethod;
    private final Method m_originalMethod;
    private final Class m_declaringClass;

    public MethodTuple(Method wrapperMethod, Method originalMethod) {
        if (originalMethod == null) {
            originalMethod = wrapperMethod;
        }
        if (wrapperMethod.getDeclaringClass() != originalMethod.getDeclaringClass()) {
            throw new RuntimeException(wrapperMethod.getName() + " and " + originalMethod.getName() + " does not have the same declaring class");
        }
        this.m_declaringClass = wrapperMethod.getDeclaringClass();
        this.m_wrapperMethod = wrapperMethod;
        this.m_wrapperMethod.setAccessible(true);
        this.m_originalMethod = originalMethod;
        this.m_originalMethod.setAccessible(true);
    }

    public boolean isWrapped() {
        return this.m_originalMethod != null;
    }

    public Class getDeclaringClass() {
        return this.m_declaringClass;
    }

    public Method getWrapperMethod() {
        return this.m_wrapperMethod;
    }

    public Method getOriginalMethod() {
        return this.m_originalMethod;
    }

    public String getName() {
        return this.m_wrapperMethod.getName();
    }
}

