/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.joinpoint.management;

public final class JoinPointType {
    public static final int METHOD_EXECUTION_INT = 1;
    public static final int METHOD_CALL_INT = 2;
    public static final int CONSTRUCTOR_EXECUTION_INT = 3;
    public static final int CONSTRUCTOR_CALL_INT = 4;
    public static final int FIELD_SET_INT = 5;
    public static final int FIELD_GET_INT = 6;
    public static final int HANDLER_INT = 7;
    public static final int STATIC_INITIALIZATION_INT = 8;
    public static final JoinPointType METHOD_EXECUTION = new JoinPointType(1);
    public static final JoinPointType METHOD_CALL = new JoinPointType(2);
    public static final JoinPointType CONSTRUCTOR_EXECUTION = new JoinPointType(3);
    public static final JoinPointType CONSTRUCTOR_CALL = new JoinPointType(4);
    public static final JoinPointType FIELD_SET = new JoinPointType(5);
    public static final JoinPointType FIELD_GET = new JoinPointType(6);
    public static final JoinPointType HANDLER = new JoinPointType(7);
    public static final JoinPointType STATIC_INITIALIZATION = new JoinPointType(8);
    private int m_int;

    private JoinPointType(int asInt) {
        this.m_int = asInt;
    }

    public String toString() {
        switch (this.m_int) {
            case 1: {
                return "MethodExecution";
            }
            case 2: {
                return "MethodCall";
            }
            case 3: {
                return "ConstructorExecution";
            }
            case 4: {
                return "ConstructorCall";
            }
            case 6: {
                return "FieldGet";
            }
            case 5: {
                return "FieldSet";
            }
            case 7: {
                return "Handler";
            }
            case 8: {
                return "StaticInitialization";
            }
        }
        throw new Error("not supported join point type");
    }

    public static JoinPointType fromInt(int asInt) {
        return new JoinPointType(asInt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JoinPointType)) {
            return false;
        }
        JoinPointType joinPointType = (JoinPointType)o;
        return this.m_int == joinPointType.m_int;
    }

    public int hashCode() {
        return this.m_int;
    }
}

