/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect.impl.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.aspectwerkz.annotation.instrumentation.asm.AsmAnnotationHelper;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassReader;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.org.objectweb.asm.attrs.Attributes;
import org.codehaus.aspectwerkz.proxy.ProxyCompiler;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.FieldInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfoRepository;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmMemberInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.FieldStruct;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;

public class AsmFieldInfo
extends AsmMemberInfo
implements FieldInfo {
    private String m_typeName;
    private ClassInfo m_type = null;

    AsmFieldInfo(FieldStruct field, String declaringType, ClassLoader loader) {
        super(field, declaringType, loader);
        this.m_typeName = Type.getType(field.desc).getClassName();
    }

    public static FieldInfo getFieldInfo(String fieldName, String fieldDesc, byte[] bytecode, ClassLoader loader) {
        String className = AsmClassInfo.retrieveClassNameFromBytecode(bytecode);
        AsmClassInfoRepository repository = AsmClassInfoRepository.getRepository(loader);
        ClassInfo classInfo = repository.getClassInfo(className);
        if (classInfo == null) {
            classInfo = AsmClassInfo.getClassInfo(bytecode, loader);
        }
        return classInfo.getField(AsmHelper.calculateFieldHash(fieldName, fieldDesc));
    }

    public String getSignature() {
        return AsmHelper.getFieldDescriptor(this);
    }

    public ClassInfo getType() {
        if (this.m_type == null) {
            this.m_type = AsmClassInfo.getClassInfo(this.m_typeName, (ClassLoader)this.m_loaderRef.get());
        }
        return this.m_type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAnnotations() {
        if (this.m_annotations == null) {
            try {
                InputStream in = null;
                ClassReader cr = null;
                try {
                    in = (ClassLoader)this.m_loaderRef.get() != null ? ((ClassLoader)this.m_loaderRef.get()).getResourceAsStream(this.m_declaringTypeName.replace('.', '/') + ".class") : ClassLoader.getSystemClassLoader().getResourceAsStream(this.m_declaringTypeName.replace('.', '/') + ".class");
                    if (in == null) {
                        in = ProxyCompiler.getProxyResourceAsStream((ClassLoader)this.m_loaderRef.get(), this.m_declaringTypeName);
                    }
                    cr = new ClassReader(in);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
                ArrayList annotations = new ArrayList();
                cr.accept(new AsmAnnotationHelper.FieldAnnotationExtractor(annotations, this.m_member.name, (ClassLoader)this.m_loaderRef.get()), Attributes.getDefaultAttributes(), true);
                this.m_annotations = annotations;
            }
            catch (IOException e) {
                System.err.println("WARN - could not load " + this.m_declaringTypeName + " as a resource to retrieve annotations");
                this.m_annotations = AsmClassInfo.EMPTY_LIST;
            }
        }
        return this.m_annotations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldInfo)) {
            return false;
        }
        FieldInfo fieldInfo = (FieldInfo)o;
        if (!this.m_declaringTypeName.equals(fieldInfo.getDeclaringType().getName())) {
            return false;
        }
        if (!this.m_member.name.equals(fieldInfo.getName())) {
            return false;
        }
        return this.m_typeName.equals(fieldInfo.getType().getName());
    }

    public int hashCode() {
        int result = 29;
        result = 29 * result + this.m_declaringTypeName.hashCode();
        result = 29 * result + this.m_member.name.hashCode();
        result = 29 * result + this.m_typeName.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.m_declaringTypeName);
        sb.append('.').append(this.m_member.name).append(' ');
        sb.append(this.m_member.desc);
        return sb.toString();
    }
}

