/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining;

import java.util.StringTokenizer;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.transform.inlining.spi.AspectModel;
import org.codehaus.aspectwerkz.util.ContextClassLoader;

public class AspectModelManager {
    public static final String ASPECT_MODELS_VM_OPTION = "aspectwerkz.extension.aspectmodels";
    private static final String DELIMITER = ":";
    private static AspectModel[] ASPECT_MODELS = new AspectModel[0];

    public static AspectModel[] getModels() {
        return ASPECT_MODELS;
    }

    public static AspectModel getModelFor(String type) {
        for (int i = 0; i < ASPECT_MODELS.length; ++i) {
            AspectModel aspectModel = ASPECT_MODELS[i];
            if (!aspectModel.getAspectModelType().equals(type)) continue;
            return aspectModel;
        }
        return null;
    }

    public static void defineAspect(ClassInfo aspectClassInfo, AspectDefinition aspectDef, ClassLoader loader) {
        for (int i = 0; i < ASPECT_MODELS.length; ++i) {
            ASPECT_MODELS[i].defineAspect(aspectClassInfo, aspectDef, loader);
        }
    }

    private static void registerAspectModels(String aspectModels) {
        if (aspectModels != null) {
            StringTokenizer tokenizer = new StringTokenizer(aspectModels, DELIMITER);
            ASPECT_MODELS = new AspectModel[tokenizer.countTokens()];
            for (int i = 0; i < ASPECT_MODELS.length; ++i) {
                String className = tokenizer.nextToken();
                try {
                    Class modelClass = ContextClassLoader.forName(className);
                    AspectModelManager.ASPECT_MODELS[i] = (AspectModel)modelClass.newInstance();
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new DefinitionException("aspect model implementation class not found [" + className + "]: " + e.toString());
                }
                catch (Exception e) {
                    throw new DefinitionException("aspect model implementation class could not be instantiated [" + className + "] - make sure it has a default no argument constructor: " + e.toString());
                }
            }
        }
    }

    static {
        AspectModelManager.registerAspectModels(System.getProperty(ASPECT_MODELS_VM_OPTION, null));
    }
}

