/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data;

import java.util.ArrayList;
import org.apache.avalon.composition.data.CategoriesDirective;
import org.apache.avalon.composition.data.ClassLoaderDirective;
import org.apache.avalon.composition.data.ClasspathDirective;
import org.apache.avalon.composition.data.LibraryDirective;
import org.apache.avalon.composition.data.Mode;
import org.apache.avalon.composition.data.Profile;
import org.apache.avalon.composition.data.ServiceDirective;

public class ContainmentProfile
extends Profile {
    public static final String DELIMITER = "/";
    private static final ServiceDirective[] EMPTY_SERVICES = new ServiceDirective[0];
    private static final Profile[] EMPTY_PROFILES = new Profile[0];
    private static final CategoriesDirective EMPTY_CATEGORIES = new CategoriesDirective();
    private static final ClassLoaderDirective EMPTY_CLASSLOADER = new ClassLoaderDirective(new LibraryDirective(), new ClasspathDirective());
    private ClassLoaderDirective m_classloader;
    private final ServiceDirective[] m_export;
    private final Profile[] m_profiles;
    private CategoriesDirective m_categories;

    public ContainmentProfile() {
        this("container", null, null, null, null);
    }

    public ContainmentProfile(String name, ClassLoaderDirective classloader, ServiceDirective[] exports, CategoriesDirective categories, Profile[] profiles) {
        super(name, true, Mode.EXPLICIT);
        this.m_categories = categories;
        this.m_classloader = classloader;
        this.m_profiles = profiles;
        this.m_export = exports;
    }

    public CategoriesDirective getCategories() {
        if (this.m_categories == null) {
            return EMPTY_CATEGORIES;
        }
        return this.m_categories;
    }

    public ClassLoaderDirective getClassLoaderDirective() {
        if (this.m_classloader == null) {
            return EMPTY_CLASSLOADER;
        }
        return this.m_classloader;
    }

    public ServiceDirective[] getExportDirectives() {
        if (this.m_export == null) {
            return EMPTY_SERVICES;
        }
        return this.m_export;
    }

    public ServiceDirective getExportDirective(Class clazz) {
        String classname = clazz.getName();
        ServiceDirective[] services = this.getExportDirectives();
        for (int i = 0; i < services.length; ++i) {
            ServiceDirective virtual = services[i];
            if (!virtual.getReference().getClassname().equals(classname)) continue;
            return virtual;
        }
        return null;
    }

    public Profile[] getProfiles() {
        if (this.m_profiles == null) {
            return EMPTY_PROFILES;
        }
        return this.m_profiles;
    }

    public Profile[] getProfiles(Mode mode) {
        Profile[] profiles = this.getProfiles();
        return this.selectProfileByMode(profiles, mode);
    }

    private Profile[] selectProfileByMode(Profile[] profiles, Mode mode) {
        ArrayList<Profile> list = new ArrayList<Profile>();
        for (int i = 0; i < profiles.length; ++i) {
            Profile profile = profiles[i];
            if (!profile.getMode().equals(mode)) continue;
            list.add(profile);
        }
        return list.toArray(new Profile[0]);
    }
}

