/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data;

import java.util.ArrayList;
import org.apache.avalon.composition.data.TargetDirective;

public class Targets {
    private final TargetDirective[] m_targets;

    public Targets() {
        this.m_targets = new TargetDirective[0];
    }

    public Targets(TargetDirective[] targets) {
        this.m_targets = targets;
    }

    public TargetDirective[] getTargets() {
        return this.m_targets;
    }

    public TargetDirective getTarget(String path) {
        String key = this.getKey(path);
        for (int i = 0; i < this.m_targets.length; ++i) {
            TargetDirective target = this.m_targets[i];
            if (!target.getPath().equals(key)) continue;
            return target;
        }
        return null;
    }

    public Targets getTargets(String path) {
        String key = this.getKey(path);
        ArrayList<TargetDirective> list = new ArrayList<TargetDirective>();
        for (int i = 0; i < this.m_targets.length; ++i) {
            String name;
            TargetDirective target = this.m_targets[i];
            if (!target.getPath().startsWith(key) || (name = target.getPath().substring(key.length())).length() <= 0) continue;
            list.add(new TargetDirective(this.getKey(name), target.getConfiguration(), target.getCategoriesDirective()));
        }
        return new Targets(list.toArray(new TargetDirective[0]));
    }

    private String getKey(String path) throws IllegalArgumentException {
        if (!path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[targets: ");
        for (int i = 0; i < this.m_targets.length; ++i) {
            buffer.append(this.m_targets[i]);
            if (i >= this.m_targets.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(" ]");
        return buffer.toString();
    }
}

