/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.controller;

import be.dnsbelgium.core.DomainName;
import be.dnsbelgium.rdap.core.Domain;
import be.dnsbelgium.rdap.core.RDAPError;
import be.dnsbelgium.rdap.service.DomainService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"domain"})
public final class DomainController {
    private final Logger logger = LoggerFactory.getLogger(DomainController.class);
    private final String baseRedirectURL;
    private final DomainService domainService;

    @Autowired
    public DomainController(@Value(value="${baseRedirectURL}") String baseRedirectURL, DomainService domainService) {
        this.baseRedirectURL = baseRedirectURL;
        this.domainService = domainService;
    }

    @RequestMapping(value={"/{domainName}"}, method={RequestMethod.GET}, produces={"application/rdap+json;charset=UTF-8"})
    @ResponseBody
    public Domain get(@PathVariable(value="domainName") String domainName) throws RDAPError {
        this.logger.debug("Query(GET) for domain {}", (Object)domainName);
        Domain result = this.getDomain(domainName);
        return result;
    }

    private Domain getDomain(@PathVariable(value="domainName") String domainName) throws RDAPError {
        DomainName dn = DomainName.of((String)domainName);
        Domain result = this.domainService.getDomain(dn);
        if (result == null) {
            this.logger.debug("Domain result for '{}' is null. Throwing DomainNotFound Error", (Object)domainName);
            throw RDAPError.domainNotFound((DomainName)dn);
        }
        return result;
    }

    @RequestMapping(value={"/{domainName}"}, method={RequestMethod.HEAD}, produces={"application/rdap+json;charset=UTF-8"})
    public ResponseEntity<Void> head(@PathVariable(value="domainName") String domainName) throws RDAPError {
        this.logger.debug("Query(HEAD) for domain {}", (Object)domainName);
        Domain result = this.getDomain(domainName);
        return new ResponseEntity(null, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @ExceptionHandler(value={RDAPError.NotAuthoritative.class})
    @ResponseBody
    protected RDAPError handleResourceNotFoundException(RDAPError.NotAuthoritative error, HttpServletResponse response) throws UnsupportedEncodingException {
        response.setStatus(error.getErrorCode());
        String location = this.baseRedirectURL + "/domain/" + URLEncoder.encode(error.getDomainName(), "UTF-8");
        response.addHeader("Location", location);
        return error;
    }

    @RequestMapping(value={"/{domainName}"}, method={RequestMethod.DELETE, RequestMethod.PUT, RequestMethod.OPTIONS, RequestMethod.PATCH, RequestMethod.POST, RequestMethod.TRACE}, produces={"application/rdap+json;charset=UTF-8"})
    @ResponseBody
    public Domain any(@PathVariable(value="domainName") String domainName) throws RDAPError {
        throw RDAPError.methodNotAllowed();
    }
}

