/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.controller;

import be.dnsbelgium.rdap.core.Entity;
import be.dnsbelgium.rdap.core.RDAPError;
import be.dnsbelgium.rdap.service.EntityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"entity"})
public class EntityController {
    private static final Logger logger = LoggerFactory.getLogger(EntityController.class);
    private final EntityService entityService;

    @Autowired
    public EntityController(EntityService entityService) {
        this.entityService = entityService;
    }

    @RequestMapping(value={"/{handle}"}, method={RequestMethod.GET}, produces={"application/rdap+json;charset=UTF-8"})
    @ResponseBody
    public Entity get(@PathVariable(value="handle") String handle) throws RDAPError {
        logger.debug("Query(GET) for entity with handle: {}", (Object)handle);
        Entity entity = this.entityService.getEntity(handle);
        if (entity == null) {
            logger.debug("Entity result for {} is null. Throwing EntityNotFound Error", (Object)handle);
            throw RDAPError.entityNotFound((String)handle);
        }
        return entity;
    }

    @RequestMapping(value={"/{handle}"}, method={RequestMethod.HEAD}, produces={"application/rdap+json;charset=UTF-8"})
    public ResponseEntity<Void> head(@PathVariable(value="handle") String handle) throws RDAPError {
        logger.debug("Query(HEAD) for entity with handle: {}", (Object)handle);
        Entity entity = this.entityService.getEntity(handle);
        if (entity == null) {
            logger.debug("Entity result for {} is null. Throwing EntityNotFound Error", (Object)handle);
            throw RDAPError.entityNotFound((String)handle);
        }
        return new ResponseEntity(null, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @RequestMapping(value={"/{handle}"}, method={RequestMethod.DELETE, RequestMethod.PUT, RequestMethod.OPTIONS, RequestMethod.PATCH, RequestMethod.POST, RequestMethod.TRACE}, produces={"application/rdap+json;charset=UTF-8"})
    @ResponseBody
    public Entity any(@PathVariable(value="handle") String handle) throws RDAPError {
        throw RDAPError.methodNotAllowed();
    }
}

