/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.controller;

import be.dnsbelgium.core.CIDR;
import be.dnsbelgium.rdap.core.IPNetwork;
import be.dnsbelgium.rdap.core.RDAPError;
import be.dnsbelgium.rdap.service.IPService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ip"})
public final class IPController {
    private static final Logger logger = LoggerFactory.getLogger(IPController.class);
    private final IPService ipService;

    @Autowired
    public IPController(IPService ipService) {
        this.ipService = ipService;
    }

    @RequestMapping(value={"/{ipaddress}"}, method={RequestMethod.GET}, produces={"application/rdap+json;charset=UTF-8"})
    @ResponseBody
    public IPNetwork get(@PathVariable(value="ipaddress") String ipAddress) throws RDAPError {
        logger.debug("Query for ip {}", (Object)ipAddress);
        return this.getNetwork(ipAddress);
    }

    @RequestMapping(value={"/{ipaddress}/{size}"}, method={RequestMethod.GET}, produces={"application/rdap+json;charset=UTF-8"})
    @ResponseBody
    public IPNetwork get(@PathVariable(value="ipaddress") String ipAddress, @PathVariable(value="size") int size) throws RDAPError {
        ipAddress = ipAddress + "/" + size;
        return this.getNetwork(ipAddress);
    }

    private IPNetwork getNetwork(String ipAddress) throws RDAPError {
        IPNetwork ipNetwork;
        try {
            ipNetwork = this.ipService.getIPNetwork(CIDR.of((String)ipAddress));
            if (ipNetwork == null) {
                logger.debug("IP result for {} is null. Throwing IPNotFound Error", (Object)ipAddress);
                throw RDAPError.ipNotFound((String)ipAddress);
            }
        }
        catch (RDAPError e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Some errors not handled", (Throwable)e);
            throw new RDAPError(HttpStatus.INTERNAL_SERVER_ERROR.value(), "Internal server error");
        }
        return ipNetwork;
    }
}

