/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.controller;

import be.dnsbelgium.rdap.core.DomainsSearchResult;
import be.dnsbelgium.rdap.core.Nameserver;
import be.dnsbelgium.rdap.core.RDAPError;
import be.dnsbelgium.rdap.service.DomainService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"domains"})
public class SearchDomainsController {
    private static final Logger logger = LoggerFactory.getLogger(SearchDomainsController.class);
    private final DomainService domainService;

    @Autowired
    public SearchDomainsController(DomainService domainService) {
        this.domainService = domainService;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/rdap+json;charset=UTF-8"})
    @ResponseBody
    public DomainsSearchResult search(@RequestParam(value="name", required=false) String name, @RequestParam(value="nsLdhName", required=false) String nsLdhName, @RequestParam(value="nsIp", required=false) String nsIp) throws RDAPError {
        this.checkParams(name, nsLdhName, nsIp);
        if (name != null) {
            return this.handleByNameSearch(name);
        }
        if (nsLdhName != null) {
            return this.handleByNsLdhNameSearch(nsLdhName);
        }
        return this.handleByNsIpSearch(nsIp);
    }

    @RequestMapping(method={RequestMethod.DELETE, RequestMethod.PUT, RequestMethod.OPTIONS, RequestMethod.PATCH, RequestMethod.POST, RequestMethod.TRACE}, produces={"application/rdap+json;charset=UTF-8"})
    @ResponseBody
    public Nameserver any(@RequestParam(value="name", required=false) String name, @RequestParam(value="nsLdhName", required=false) String nsLdhName, @RequestParam(value="nsIp", required=false) String nsIp) throws RDAPError {
        throw RDAPError.methodNotAllowed();
    }

    private DomainsSearchResult handleByNsIpSearch(String nsIp) throws RDAPError {
        DomainsSearchResult domains = this.domainService.searchDomainsByNsIp(nsIp);
        if (domains == null) {
            throw RDAPError.noResults((String)nsIp);
        }
        return domains;
    }

    private DomainsSearchResult handleByNsLdhNameSearch(String nsLdhName) throws RDAPError {
        DomainsSearchResult domains = this.domainService.searchDomainsByNsLdhName(nsLdhName);
        if (domains == null) {
            throw RDAPError.noResults((String)nsLdhName);
        }
        return domains;
    }

    private DomainsSearchResult handleByNameSearch(String name) throws RDAPError {
        DomainsSearchResult domains = this.domainService.searchDomainsByName(name);
        if (domains == null || domains.domainSearchResults == null || domains.domainSearchResults.isEmpty()) {
            throw RDAPError.noResults((String)name);
        }
        return domains;
    }

    private void checkParams(String name, String nsLdhName, String nsIp) throws RDAPError {
        if (name == null && nsLdhName == null && nsIp == null) {
            throw RDAPError.badRequest((String)"Param missing", (String)"One and only one of 'name', 'nsLdhName' or 'nsIp' should be provided");
        }
        int paramCount = 0;
        if (name != null) {
            ++paramCount;
        }
        if (nsLdhName != null) {
            ++paramCount;
        }
        if (nsIp != null) {
            ++paramCount;
        }
        if (paramCount > 1) {
            throw RDAPError.badRequest((String)"Too many params", (String)"One and only one of 'name', 'nsLdhName' or 'nsIp' should be provided");
        }
    }
}

