/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.controller;

import be.dnsbelgium.rdap.core.EntitiesSearchResult;
import be.dnsbelgium.rdap.core.Nameserver;
import be.dnsbelgium.rdap.core.RDAPError;
import be.dnsbelgium.rdap.service.EntityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"entities"})
public class SearchEntitiesController {
    private static final Logger logger = LoggerFactory.getLogger(SearchEntitiesController.class);
    private final EntityService entityService;

    @Autowired
    public SearchEntitiesController(EntityService entityService) {
        this.entityService = entityService;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/rdap+json;charset=UTF-8"})
    @ResponseBody
    public EntitiesSearchResult search(@RequestParam(value="fn", required=false) String fn, @RequestParam(value="handle", required=false) String handle) throws RDAPError {
        EntitiesSearchResult result = null;
        String query = this.checkParams(fn, handle);
        if (fn != null) {
            result = this.entityService.searchByFn(fn);
        }
        if (handle != null) {
            result = this.entityService.searchByHandle(handle);
        }
        if (result == null || result.entitySearchResults == null || result.entitySearchResults.isEmpty()) {
            throw RDAPError.noResults((String)query);
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.DELETE, RequestMethod.PUT, RequestMethod.OPTIONS, RequestMethod.PATCH, RequestMethod.POST, RequestMethod.TRACE}, produces={"application/rdap+json;charset=UTF-8"})
    @ResponseBody
    public Nameserver any(@RequestParam(value="fn", required=false) String fn, @RequestParam(value="handle", required=false) String handle) throws RDAPError {
        throw RDAPError.methodNotAllowed();
    }

    private String checkParams(String fn, String handle) throws RDAPError {
        if (fn == null && handle == null) {
            throw RDAPError.badRequest((String)"Param missing", (String)"One and only one of 'fn' or 'handle' should be provided");
        }
        if (fn != null && handle != null) {
            throw RDAPError.badRequest((String)"Too many params", (String)"One and only one of 'fn' or 'handle' should be provided");
        }
        return fn != null ? fn : handle;
    }
}

