/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.exception;

import be.dnsbelgium.core.LabelException;
import be.dnsbelgium.rdap.core.RDAPError;
import com.ibm.icu.text.IDNA;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionAdvice {
    private final Logger logger = LoggerFactory.getLogger(ExceptionAdvice.class);

    @ExceptionHandler(value={RDAPError.class})
    @ResponseBody
    public HttpEntity<RDAPError> handleRdapError(RDAPError error, HttpServletResponse response) {
        response.setStatus(error.getErrorCode());
        return this.wrapRdapErrorInHttpEntityAndSetContentType(error);
    }

    @ExceptionHandler(value={LabelException.IDNParseException.class})
    @ResponseBody
    public HttpEntity<RDAPError> handleIDNParseException(LabelException.IDNParseException ipe, HttpServletResponse response) {
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        ArrayList<String> description = new ArrayList<String>();
        for (IDNA.Error error : ipe.getErrors()) {
            description.add(error.name());
        }
        return this.wrapRdapErrorInHttpEntityAndSetContentType((RDAPError)RDAPError.badRequest((String)"Invalid domain name", description));
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    @ResponseBody
    public ResponseEntity<String> handleUnsupportedMediaType(HttpMediaTypeNotAcceptableException hmtnae, HttpServletResponse response) throws IOException {
        response.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
        return null;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public HttpEntity<RDAPError> handleUnhandledException(Exception e, HttpServletResponse response) {
        this.logger.error("Some errors not handled", (Throwable)e);
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return this.wrapRdapErrorInHttpEntityAndSetContentType(new RDAPError(HttpStatus.INTERNAL_SERVER_ERROR.value(), "Internal server error"));
    }

    private HttpEntity<RDAPError> wrapRdapErrorInHttpEntityAndSetContentType(RDAPError response) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/rdap+json;charset=UTF-8");
        return new HttpEntity((Object)response, (MultiValueMap)headers);
    }
}

