/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.security.seraph;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import net.incongru.berkano.security.Role;
import net.incongru.berkano.user.Group;
import net.incongru.berkano.user.User;

public class UserRoleCache {
    private static final String ROLE_CACHE_KEY = UserRoleCache.class.getName();

    Set getRoles(Principal principal, HttpServletRequest req) {
        if (principal == null) {
            return Collections.EMPTY_SET;
        }
        if (!(principal instanceof User)) {
            throw new IllegalStateException("UserRoleCache can only work with berkano-user!");
        }
        HashSet<Role> permissions = (HashSet<Role>)req.getAttribute(ROLE_CACHE_KEY);
        if (permissions == null) {
            permissions = new HashSet<Role>();
            User user = (User)principal;
            Set groups = user.getGroups();
            Iterator it = groups.iterator();
            while (it.hasNext()) {
                Group group = (Group)it.next();
                Set roles = group.getRoles();
                if (roles == null) continue;
                Iterator itRoles = roles.iterator();
                while (itRoles.hasNext()) {
                    Role role = (Role)itRoles.next();
                    permissions.add(role);
                }
            }
            req.setAttribute(ROLE_CACHE_KEY, permissions);
        }
        return permissions;
    }
}

