/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.user.hibernate;

import java.io.Serializable;
import java.util.List;
import net.incongru.berkano.security.password.PasswordMatchingStrategy;
import net.incongru.berkano.user.GroupImpl;
import net.incongru.berkano.user.PropertiesAware;
import net.incongru.berkano.user.UnknownUserException;
import net.incongru.berkano.user.User;
import net.incongru.berkano.user.UserDAO;
import net.incongru.berkano.user.UserImpl;
import net.incongru.berkano.user.hibernate.AbstractHibernatedDAO;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Expression;

public class HibernatedUserDAO
extends AbstractHibernatedDAO
implements UserDAO {
    private PasswordMatchingStrategy passwordMatchingStrategy;

    public HibernatedUserDAO(Session session, PasswordMatchingStrategy passwordMatchingStrategy) {
        super(session);
        this.passwordMatchingStrategy = passwordMatchingStrategy;
    }

    protected PropertiesAware getById(Long id) throws UnknownUserException {
        return (PropertiesAware)((Object)this.getUserById(id));
    }

    public void addProperty(User user, String propertyKey, Object value) throws UnknownUserException {
        try {
            this.session.lock((Object)user, LockMode.READ);
            ((UserImpl)user).getProperties().put(propertyKey, value);
            this.session.save((Object)user);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public User getUserById(Long userId) throws UnknownUserException {
        try {
            User user = (User)this.session.get(UserImpl.class, (Serializable)userId);
            if (user == null) {
                throw new UnknownUserException(userId);
            }
            return user;
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public User getUserByName(String userName) {
        return this.getUserByField("userName", userName);
    }

    public User getUserByEmail(String email) {
        return this.getUserByField("email", email);
    }

    private User getUserByField(String fieldName, String value) {
        try {
            Criteria criteria = this.session.createCriteria(UserImpl.class);
            criteria.add((Criterion)Expression.eq((String)fieldName, (Object)value).ignoreCase());
            User user = (User)criteria.uniqueResult();
            return user;
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean removeUser(Long userId) throws UnknownUserException {
        try {
            UserImpl user = (UserImpl)this.session.load(UserImpl.class, (Serializable)userId);
            this.session.delete((Object)user);
            if (user == null) {
                throw new UnknownUserException(userId);
            }
            return true;
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public List listAllUsers() {
        try {
            List list = this.session.createCriteria(UserImpl.class).list();
            return list;
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public User newUser(String userName, String password, String email, String fullName) {
        try {
            UserImpl newUser = new UserImpl();
            newUser.setUserName(userName);
            newUser.setPassword(this.passwordMatchingStrategy.encode(password));
            newUser.setEmail(email);
            newUser.setFullName(fullName);
            this.session.save((Object)newUser);
            return newUser;
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public User updateUser(Long userId, String userName, String email, String fullName) throws UnknownUserException {
        try {
            UserImpl user = (UserImpl)this.getUserById(userId);
            user.setUserName(userName);
            user.setFullName(fullName);
            user.setEmail(email);
            this.session.update((Object)user);
            return user;
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public void changePassword(Long userId, String newPassword) throws UnknownUserException {
        try {
            UserImpl user = (UserImpl)this.getUserById(userId);
            user.setPassword(this.passwordMatchingStrategy.encode(newPassword));
            this.session.update((Object)user);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public void addToGroup(Long userId, Long groupId) throws UnknownUserException {
        try {
            GroupImpl group = (GroupImpl)this.session.get(GroupImpl.class, (Serializable)groupId);
            UserImpl user = (UserImpl)this.getUserById(userId);
            user.getGroups().add(group);
            group.getUsers().add(user);
            this.session.save((Object)user);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeFromGroup(Long userId, Long groupId) throws UnknownUserException {
        try {
            GroupImpl group = (GroupImpl)this.session.get(GroupImpl.class, (Serializable)groupId);
            UserImpl user = (UserImpl)this.getUserById(userId);
            user.getGroups().remove(group);
            group.getUsers().remove(user);
            this.session.save((Object)user);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }
}

