/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.incongru.berkano.security.Authenticator;
import net.incongru.berkano.security.password.PasswordMatchingStrategy;
import net.incongru.berkano.user.UnknownUserException;
import net.incongru.berkano.user.User;
import net.incongru.berkano.user.UserDAO;

public class BasicHttpAuthenticator
implements Authenticator {
    private UserDAO userDAO;
    private PasswordMatchingStrategy passwordMatchingStrategy;
    private HttpServletRequest req;
    private static final String USER_KEY = "berkano.user";

    public BasicHttpAuthenticator(HttpServletRequest req, UserDAO userDAO, PasswordMatchingStrategy passwordMatchingStrategy) {
        this.req = req;
        this.userDAO = userDAO;
        this.passwordMatchingStrategy = passwordMatchingStrategy;
    }

    public boolean authenticate() throws UnknownUserException {
        String username = this.req.getParameter("berkano.username");
        String password = this.req.getParameter("berkano.password");
        User user = this.userDAO.getUserByName(username);
        if (user != null && this.passwordMatchingStrategy.matches(password, user)) {
            this.req.getSession(true).setAttribute(USER_KEY, (Object)user);
            return true;
        }
        return false;
    }

    public boolean logout() {
        HttpSession session = this.req.getSession(false);
        if (session != null) {
            session.removeAttribute(USER_KEY);
        }
        return true;
    }
}

