/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.user.hibernate;

import net.incongru.berkano.user.PropertiesAware;
import net.incongru.berkano.user.UnknownUserException;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public abstract class AbstractHibernatedDAO {
    protected Session session;

    public AbstractHibernatedDAO(Session session) {
        this.session = session;
    }

    protected abstract PropertiesAware getById(Long var1) throws UnknownUserException;

    public void addProperty(Long id, String propertyKey, Object value) throws UnknownUserException {
        PropertiesAware o = this.getById(id);
        this.addProperty(o, propertyKey, value);
    }

    public void addProperty(PropertiesAware o, String propertyKey, Object value) {
        try {
            o.getProperties().put(propertyKey, value);
            this.session.save((Object)o);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeProperty(Long id, String propertyKey) throws UnknownUserException {
        try {
            PropertiesAware o = this.getById(id);
            o.getProperties().remove(propertyKey);
            this.session.save((Object)o);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }
}

