/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.security.password.retrieval;

import java.util.HashMap;
import java.util.Map;
import net.incongru.berkano.security.password.PasswordRetrievalStrategy;
import net.incongru.berkano.user.User;
import net.incongru.util.mail.Mailer;

public abstract class AbstractMailPasswordRetrievalStrategy
implements PasswordRetrievalStrategy {
    private Mailer mailer;

    protected AbstractMailPasswordRetrievalStrategy(Mailer mailer) {
        this.mailer = mailer;
    }

    public void retrievePassword(User u) throws Exception {
        Map map = this.prepare(u);
        this.mailer.mail(u.getEmail(), u.getFullName(), this.getMailSubject(), this.getTemplateName(), map);
    }

    protected Map prepare(User u) {
        HashMap<String, User> map = new HashMap<String, User>();
        map.put("user", u);
        return map;
    }

    protected abstract String getMailSubject();

    protected abstract String getTemplateName();

    public String getRequiredField() {
        return "email";
    }
}

