/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.netbeans.maven;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.mevenide.netbeans.api.customizer.OriginChange;
import org.mevenide.netbeans.api.customizer.changes.MavenPropertyChange;

public class ComboBoxPropertyChange
implements MavenPropertyChange {
    private String key;
    private String value;
    private int location;
    private String newValue;
    private int newLocation;
    private String defaultValue;
    private JComboBox field;
    private OriginChange origin;
    private DocListener listener;
    private boolean ignore = false;

    public ComboBoxPropertyChange(String keyParam, String oldValue, int oldLocation, JComboBox combo, OriginChange oc, String defVal) {
        this.key = keyParam;
        this.value = oldValue != null ? oldValue : "";
        this.location = oldLocation;
        this.newValue = this.value;
        this.newLocation = oldLocation;
        this.field = combo;
        this.origin = oc;
        this.defaultValue = defVal;
        this.origin.setInitialLocationID(oldLocation);
        this.field.setSelectedItem(this.value);
        this.listener = new DocListener();
        this.origin.setChangeObserver((OriginChange.ChangeObserver)this.listener);
        ComboBoxEditor editor = this.field.getEditor();
        if (editor.getEditorComponent() instanceof JTextField) {
            ((JTextField)editor.getEditorComponent()).getDocument().addDocumentListener(this.listener);
        }
        this.field.addActionListener(this.listener);
    }

    public void startIgnoringChanges() {
        this.ignore = true;
    }

    public void stopIgnoringChanges() {
        this.field.setSelectedItem(this.newValue);
        this.origin.setInitialLocationID(this.newLocation);
        this.ignore = false;
    }

    public String getKey() {
        return this.key;
    }

    public int getNewLocation() {
        return this.newLocation;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public int getOldLocation() {
        return this.location;
    }

    public String getOldValue() {
        return this.value;
    }

    public boolean hasChanged() {
        return this.newLocation != this.location || !this.getOldValue().equals(this.getNewValue());
    }

    public void setResolvedValue(String resvalue) {
        this.ignore = true;
        this.field.setEditable(false);
        this.origin.getComponent().setEnabled(false);
        this.field.setSelectedItem(resvalue);
        this.ignore = false;
    }

    public void resetToNonResolvedValue() {
        this.ignore = true;
        this.field.setEditable(true);
        this.origin.getComponent().setEnabled(true);
        this.field.setSelectedItem(this.newValue);
        this.ignore = false;
    }

    private final class DocListener
    implements DocumentListener,
    OriginChange.ChangeObserver,
    ActionListener {
        private DocListener() {
        }

        private void update() {
            if (ComboBoxPropertyChange.this.ignore) {
                return;
            }
            ComboBoxPropertyChange.this.newValue = ComboBoxPropertyChange.this.field.getSelectedItem().toString();
            if (ComboBoxPropertyChange.this.origin.getSelectedLocationID() == -1 || ComboBoxPropertyChange.this.origin.getSelectedLocationID() == -2) {
                ComboBoxPropertyChange.this.origin.setAction(11);
            }
        }

        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        public void locationChanged() {
            if (ComboBoxPropertyChange.this.ignore) {
                return;
            }
            ComboBoxPropertyChange.this.newLocation = ComboBoxPropertyChange.this.origin.getSelectedLocationID();
            if (ComboBoxPropertyChange.this.newLocation < 0) {
                ComboBoxPropertyChange.this.ignore = true;
                ComboBoxPropertyChange.this.newValue = ComboBoxPropertyChange.this.defaultValue == null ? "" : ComboBoxPropertyChange.this.defaultValue;
                ComboBoxPropertyChange.this.field.setSelectedItem(ComboBoxPropertyChange.this.newValue);
                ComboBoxPropertyChange.this.ignore = false;
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.update();
        }
    }
}

