/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.netbeans.maven;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.codehaus.cargo.netbeans.maven.ComboBoxPropertyChange;
import org.mevenide.netbeans.api.customizer.LocationComboFactory;
import org.mevenide.netbeans.api.customizer.OriginChange;
import org.mevenide.netbeans.api.customizer.changes.MavenPropertyChange;
import org.mevenide.netbeans.api.customizer.changes.TextFieldPropertyChange;
import org.mevenide.netbeans.api.project.MavenProject;

public class DeployablesPanel
extends JPanel {
    private MavenProject project;
    private String deployId;
    private Set deployables;
    private boolean initialized = false;
    private HashMap changes;
    private OriginChange ocType;
    private OriginChange ocWar;
    private OriginChange ocEar;
    private JButton btnEar;
    private JButton btnRemove;
    private JButton btnType;
    private JButton btnWar;
    private JComboBox comType;
    private JSeparator jSeparator1;
    private JLabel lblEar;
    private JLabel lblID;
    private JLabel lblType;
    private JLabel lblWar;
    private JTextField txtEar;
    private JTextField txtID;
    private JTextField txtWar;

    public DeployablesPanel(MavenProject project, String id, Set deployables) {
        this.project = project;
        this.deployId = id;
        this.deployables = deployables;
        this.changes = new HashMap();
        this.initComponents();
    }

    private void initComponents() {
        this.lblID = new JLabel();
        this.txtID = new JTextField();
        this.btnRemove = new JButton();
        this.txtWar = new JTextField();
        this.txtEar = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.comType = new JComboBox();
        this.lblType = new JLabel();
        this.lblWar = new JLabel();
        this.lblEar = new JLabel();
        this.ocType = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnType = (JButton)this.ocType.getComponent();
        this.ocWar = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnWar = (JButton)this.ocWar.getComponent();
        this.ocEar = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnEar = (JButton)this.ocEar.getComponent();
        this.setLayout(new GridBagLayout());
        this.lblID.setText("Deployable ID :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.lblID, gridBagConstraints);
        this.txtID.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.txtID, gridBagConstraints);
        this.btnRemove.setText("Remove Deployable");
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeployablesPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.btnRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtWar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtEar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.comType.setModel(new DefaultComboBoxModel<String>(new String[]{"war", "ear"}));
        this.comType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeployablesPanel.this.comTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.comType, gridBagConstraints);
        this.lblType.setText("Type :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblType, gridBagConstraints);
        this.lblWar.setText("War File Path :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblWar, gridBagConstraints);
        this.lblEar.setText("Ear File Path :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblEar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnWar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnEar, gridBagConstraints);
    }

    private void comTypeActionPerformed(ActionEvent evt) {
        this.switchCombo();
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        this.deployables.remove(this.deployId);
        this.ocEar.setAction(-2);
        this.ocWar.setAction(-2);
        this.ocType.setAction(-2);
        this.getParent().remove(this);
        this.getParent().validate();
        this.getParent().repaint();
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
            this.switchCombo();
        }
    }

    private void populateChangeInstances() {
        this.txtID.setText(this.deployId);
        this.createTypeComboChangeInstance();
        this.createChangeInstance("cargo.deployable." + this.deployId + ".warfile", this.txtWar, this.ocWar);
        this.createChangeInstance("cargo.deployable." + this.deployId + ".earfile", this.txtEar, this.ocEar);
    }

    private TextFieldPropertyChange createChangeInstance(String key, JTextField field, OriginChange oc) {
        String value = this.project.getPropertyResolver().getValue(key);
        String defaultValue = this.project.getPropertyLocator().getValueAtLocation(key, -2);
        int location = this.project.getPropertyLocator().getPropertyLocation(key);
        if (value == null) {
            value = defaultValue;
            location = -2;
        }
        TextFieldPropertyChange chng = new TextFieldPropertyChange(key, value, location, field, oc, defaultValue);
        this.changes.put(key, chng);
        return chng;
    }

    private void createTypeComboChangeInstance() {
        String key = "cargo.deployable." + this.deployId + ".type";
        String value = this.project.getPropertyResolver().getValue(key);
        this.comType.setEditable(false);
        int location = this.project.getPropertyLocator().getPropertyLocation(key);
        if (value == null) {
            value = "war";
            location = -2;
        }
        ComboBoxPropertyChange chng = new ComboBoxPropertyChange(key, value, location, this.comType, this.ocType, "war");
        if (location == -2) {
            this.ocType.setAction(10);
        }
        this.changes.put(key, chng);
    }

    public List getChanges() {
        ArrayList<MavenPropertyChange> toReturn = new ArrayList<MavenPropertyChange>();
        Iterator it = this.changes.values().iterator();
        while (it.hasNext()) {
            MavenPropertyChange change = (MavenPropertyChange)it.next();
            if (!change.hasChanged()) continue;
            toReturn.add(change);
        }
        return toReturn;
    }

    private void switchCombo() {
        boolean war = "war".equals(this.comType.getSelectedItem());
        this.lblWar.setVisible(war);
        this.txtWar.setVisible(war);
        this.btnWar.setVisible(war);
        this.lblEar.setVisible(!war);
        this.txtEar.setVisible(!war);
        this.btnEar.setVisible(!war);
    }
}

