/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.netbeans.maven;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.codehaus.cargo.netbeans.maven.ComboBoxPropertyChange;
import org.mevenide.netbeans.api.customizer.LocationComboFactory;
import org.mevenide.netbeans.api.customizer.OriginChange;
import org.mevenide.netbeans.api.customizer.changes.MavenPropertyChange;
import org.mevenide.netbeans.api.customizer.changes.TextFieldPropertyChange;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.plugins.IPluginInfo;

public class SingleContainerPanel
extends JPanel {
    private IPluginInfo plugin;
    private MavenProject project;
    private String containerId;
    private boolean initialized = false;
    private HashMap changes;
    private OriginChange ocHomeDir;
    private OriginChange ocZipInstaller;
    private OriginChange ocContainerId;
    private OriginChange ocDeployables;
    private OriginChange ocOutput;
    private OriginChange ocLog;
    private Set containers;
    private Set installers;
    private Set deployables;
    private JButton btnContainerId;
    private JButton btnDeployables;
    private JButton btnHomeDir;
    private JButton btnLog;
    private JButton btnOutput;
    private JButton btnZipInstaller;
    private JComboBox comContainerId;
    private JComboBox comZipInstaller;
    private JButton jButton1;
    private JPanel jPanel1;
    private JLabel lblContainerId;
    private JLabel lblDeployables;
    private JLabel lblLog;
    private JLabel lblOutput;
    private JRadioButton rbHomeDir;
    private JRadioButton rbZipInstaller;
    private JTextField txtDeployables;
    private JTextField txtHomeDir;
    private JTextField txtLog;
    private JTextField txtOutput;

    public SingleContainerPanel(MavenProject proj, String id, IPluginInfo info, Set conts, Set installs, Set deploys) {
        this.plugin = info;
        this.project = proj;
        this.containerId = id;
        this.changes = new HashMap();
        this.containers = conts;
        this.installers = installs;
        this.deployables = deploys;
        this.initComponents();
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.rbHomeDir);
        grp.add(this.rbZipInstaller);
        ActionListener list = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SingleContainerPanel.this.switchedZipAndHome();
            }
        };
        this.rbHomeDir.addActionListener(list);
        this.rbZipInstaller.addActionListener(list);
    }

    private void switchedZipAndHome() {
        boolean sel = this.rbHomeDir.isSelected();
        this.txtHomeDir.setEnabled(sel);
        this.btnHomeDir.setEnabled(sel);
        this.comZipInstaller.setEnabled(!sel);
        this.btnZipInstaller.setEnabled(!sel);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
        }
    }

    private void populateChangeInstances() {
        this.createContainerComboChangeInstance();
        String homeDirKey = "cargo.container." + this.containerId + ".homeDir";
        this.createChangeInstance(homeDirKey, this.txtHomeDir, this.ocHomeDir);
        this.createZipComboChangeInstance();
        this.createChangeInstance("cargo.container." + this.containerId + ".log", this.txtLog, this.ocLog);
        this.createChangeInstance("cargo.container." + this.containerId + ".output", this.txtOutput, this.ocOutput);
        this.createChangeInstance("cargo.container." + this.containerId + ".deployables", this.txtDeployables, this.ocDeployables);
        this.switchedZipAndHome();
    }

    private TextFieldPropertyChange createChangeInstance(String key, JTextField field, OriginChange oc) {
        String value = this.project.getPropertyResolver().getValue(key);
        String defaultValue = this.project.getPropertyLocator().getValueAtLocation(key, -2);
        int location = this.project.getPropertyLocator().getPropertyLocation(key);
        if (value == null) {
            value = defaultValue;
            location = -2;
        }
        TextFieldPropertyChange chng = new TextFieldPropertyChange(key, value, location, field, oc, defaultValue);
        this.changes.put(key, chng);
        return chng;
    }

    private void createContainerComboChangeInstance() {
        String key = "cargo.container." + this.containerId + ".containerId";
        String value = this.project.getPropertyResolver().getValue(key);
        this.comContainerId.setEditable(false);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("resin2x");
        model.addElement("resin3x");
        model.addElement("orion1x");
        model.addElement("orion2x");
        model.addElement("tomcat3x");
        model.addElement("tomcat4x");
        model.addElement("tomcat5x");
        model.addElement("jo1x");
        model.addElement("oc4j9x");
        model.addElement("weblogic8x");
        int location = this.project.getPropertyLocator().getPropertyLocation(key);
        if (value == null) {
            value = "resin2x";
            location = -2;
        }
        ComboBoxPropertyChange chng = new ComboBoxPropertyChange(key, value, location, this.comContainerId, this.ocContainerId, "resin2x");
        this.changes.put(key, chng);
    }

    private void createZipComboChangeInstance() {
        String key = "cargo.container." + this.containerId + ".zipUrlInstaller";
        String value = this.project.getPropertyResolver().getValue(key);
        this.comContainerId.setEditable(false);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        Iterator it = this.installers.iterator();
        while (it.hasNext()) {
            String in = (String)it.next();
            model.addElement(in);
        }
        this.comZipInstaller.setModel(model);
        int location = this.project.getPropertyLocator().getPropertyLocation(key);
        if (value == null) {
            this.rbHomeDir.setSelected(true);
            value = "";
            location = -2;
        } else {
            this.rbZipInstaller.setSelected(true);
        }
        ComboBoxPropertyChange chng = new ComboBoxPropertyChange(key, value, location, this.comZipInstaller, this.ocZipInstaller, "");
        this.changes.put(key, chng);
    }

    public List getChanges() {
        ArrayList<MavenPropertyChange> toReturn = new ArrayList<MavenPropertyChange>();
        Iterator it = this.changes.values().iterator();
        while (it.hasNext()) {
            MavenPropertyChange change = (MavenPropertyChange)it.next();
            String home = "cargo.container." + this.containerId + ".homeDir";
            String zip = "cargo.container." + this.containerId + ".zipUrlInstaller";
            if (home.equals(change.getKey())) {
                if (this.rbHomeDir.isSelected()) {
                    if (change.getNewLocation() == -1 || change.getNewLocation() == -2) {
                        this.ocHomeDir.setAction(11);
                    }
                } else {
                    this.ocHomeDir.setAction(-1);
                }
            }
            if (zip.equals(change.getKey())) {
                if (this.rbZipInstaller.isSelected()) {
                    if (change.getNewLocation() == -1 || change.getNewLocation() == -2) {
                        this.ocZipInstaller.setAction(11);
                    }
                } else {
                    this.ocZipInstaller.setAction(-1);
                }
            }
            if (!change.hasChanged()) continue;
            toReturn.add(change);
        }
        return toReturn;
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.lblContainerId = new JLabel();
        this.comContainerId = new JComboBox();
        this.ocContainerId = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnContainerId = (JButton)this.ocContainerId.getComponent();
        this.rbHomeDir = new JRadioButton();
        this.txtHomeDir = new JTextField();
        this.ocHomeDir = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnHomeDir = (JButton)this.ocHomeDir.getComponent();
        this.rbZipInstaller = new JRadioButton();
        this.comZipInstaller = new JComboBox();
        this.ocZipInstaller = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnZipInstaller = (JButton)this.ocZipInstaller.getComponent();
        this.lblOutput = new JLabel();
        this.txtOutput = new JTextField();
        this.ocOutput = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnOutput = (JButton)this.ocOutput.getComponent();
        this.lblLog = new JLabel();
        this.txtLog = new JTextField();
        this.ocLog = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnLog = (JButton)this.ocLog.getComponent();
        this.lblDeployables = new JLabel();
        this.ocDeployables = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnDeployables = (JButton)this.ocDeployables.getComponent();
        this.txtDeployables = new JTextField();
        this.jPanel1 = new JPanel();
        this.jButton1.setText("jButton1");
        this.setLayout(new GridBagLayout());
        this.lblContainerId.setText("Container ID :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblContainerId, gridBagConstraints);
        this.comContainerId.setModel(new DefaultComboBoxModel<String>(new String[]{"jo1x", "resin2x", "resin3x", "orion1x", "orion2x", "oc4j9x", "tomcat3x", "tomcat4x", "tomcat5x", "weblogic8x"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.comContainerId, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnContainerId, gridBagConstraints);
        this.rbHomeDir.setText("Home Directory :");
        this.rbHomeDir.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.rbHomeDir.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.rbHomeDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtHomeDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnHomeDir, gridBagConstraints);
        this.rbZipInstaller.setText("Zip Installer :");
        this.rbZipInstaller.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.rbZipInstaller.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.rbZipInstaller, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.comZipInstaller, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnZipInstaller, gridBagConstraints);
        this.lblOutput.setText("Output File Path :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblOutput, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtOutput, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnOutput, gridBagConstraints);
        this.lblLog.setText("Log File Path :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblLog, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtLog, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnLog, gridBagConstraints);
        this.lblDeployables.setText("Deployables :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblDeployables, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnDeployables, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtDeployables, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }
}

