/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.netbeans.maven;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.codehaus.cargo.netbeans.maven.DeployablesPanel;
import org.codehaus.cargo.netbeans.maven.InstallersPanel;
import org.codehaus.cargo.netbeans.maven.SingleContainerPanel;
import org.mevenide.context.IQueryContext;
import org.mevenide.netbeans.api.customizer.LocationComboFactory;
import org.mevenide.netbeans.api.customizer.OriginChange;
import org.mevenide.netbeans.api.customizer.ProjectPanel;
import org.mevenide.netbeans.api.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.api.customizer.changes.MavenChange;
import org.mevenide.netbeans.api.customizer.changes.TextFieldPropertyChange;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.plugins.IPluginInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class UIPanel
extends JPanel
implements ProjectPanel {
    private MavenProject project;
    private IPluginInfo plugin;
    private OriginChange ocContainers;
    private OriginChange ocProxyHost;
    private OriginChange ocProxyPort;
    private OriginChange ocProxyUser;
    private OriginChange ocProxyPasswd;
    private OriginChange ocProxyExcludes;
    private Set containers;
    private Set installers;
    private Set deployables;
    private HashMap changes = new HashMap();
    private HashMap containerTabs;
    private Set deployablePanels;
    private Set installerPanels;
    private int deployableLayoutIndex = 0;
    private int installerLayoutIndex = 0;
    private ProjectValidateObserver validityObserver;
    private boolean initialized = false;
    private JButton btnContainers;
    private JButton btnProxyExcludes;
    private JButton btnProxyHost;
    private JButton btnProxyPasswd;
    private JButton btnProxyPort;
    private JButton btnProxyUser;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblContainers;
    private JLabel lblProxyExcludes;
    private JLabel lblProxyHost;
    private JLabel lblProxyPasswd;
    private JLabel lblProxyPort;
    private JLabel lblProxyUser;
    private JPanel pnlBasic;
    private JPanel pnlDeployables;
    private JPanel pnlInnerDepl;
    private JPanel pnlInnerDepl1;
    private JPanel pnlInstallers;
    private JTabbedPane tabMain;
    private JTextField txtContainers;
    private JTextField txtProxyExcludes;
    private JTextField txtProxyHost;
    private JTextField txtProxyPasswd;
    private JTextField txtProxyPort;
    private JTextField txtProxyUser;

    public UIPanel(MavenProject proj, IPluginInfo info) {
        this.plugin = info;
        this.project = proj;
        this.containerTabs = new HashMap();
        this.containers = new HashSet();
        this.installers = new HashSet();
        this.deployables = new HashSet();
        this.deployablePanels = new HashSet();
        this.installerPanels = new HashSet();
        this.initComponents();
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
            this.examineProject();
            this.updateContainerPanels();
            this.populateDeployables();
            this.populateInstallers();
            this.txtContainers.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    UIPanel.this.updateContainerPanels();
                }
            });
        }
    }

    private void examineProject() {
        IQueryContext context = this.project.getContext();
        HashSet used = new HashSet();
        used.addAll(context.getUserPropertyKeys());
        int depth = context.getPOMContext().getProjectDepth();
        for (int i = 1; i <= depth; ++i) {
            used.addAll(context.getPropertyKeysAt(i * 10 + 1));
            used.addAll(context.getPropertyKeysAt(i * 10 + 0));
        }
        Iterator keys = used.iterator();
        Pattern container = Pattern.compile("cargo\\.container\\.([a-zA-Z0-9\\-_]*)\\.containerId");
        Pattern installer = Pattern.compile("cargo\\.zipUrlInstaller\\.([a-zA-Z0-9\\-_]*)\\.installUrl");
        Pattern deployable = Pattern.compile("cargo\\.deployable\\.([a-zA-Z0-9\\-_]*)\\.type");
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Matcher match = container.matcher(key);
            if (match.matches()) {
                this.containers.add(match.group(1));
                continue;
            }
            match = installer.matcher(key);
            if (match.matches()) {
                System.out.println("matches=" + key);
                this.installers.add(match.group(1));
                System.out.println("matcher=" + match.group(1));
                continue;
            }
            match = deployable.matcher(key);
            if (!match.matches()) continue;
            this.deployables.add(match.group(1));
        }
    }

    private void populateChangeInstances() {
        this.createChangeInstance("cargo.containers", this.txtContainers, this.ocContainers);
        this.createChangeInstance("cargo.proxy.host", this.txtProxyHost, this.ocProxyHost);
        this.createChangeInstance("cargo.proxy.port", this.txtProxyPort, this.ocProxyPort);
        this.createChangeInstance("cargo.proxy.user", this.txtProxyUser, this.ocProxyUser);
        this.createChangeInstance("cargo.proxy.password", this.txtProxyPasswd, this.ocProxyPasswd);
        this.createChangeInstance("cargo.proxy.excludeHosts", this.txtProxyExcludes, this.ocProxyExcludes);
    }

    private void createChangeInstance(String key, JTextField field, OriginChange oc) {
        String value = this.project.getPropertyResolver().getValue(key);
        String defaultValue = this.project.getPropertyLocator().getValueAtLocation(key, -2);
        int location = this.project.getPropertyLocator().getPropertyLocation(key);
        if (value == null) {
            value = defaultValue;
            location = -2;
        }
        this.changes.put(key, new TextFieldPropertyChange(key, value, location, field, oc, defaultValue));
    }

    public List getChanges() {
        JPanel pan;
        ArrayList<MavenChange> toReturn = new ArrayList<MavenChange>();
        Iterator<Object> it = this.changes.values().iterator();
        while (it.hasNext()) {
            MavenChange change = (MavenChange)it.next();
            if (!change.hasChanged()) continue;
            toReturn.add(change);
        }
        it = this.containerTabs.values().iterator();
        while (it.hasNext()) {
            pan = (SingleContainerPanel)it.next();
            toReturn.addAll(((SingleContainerPanel)pan).getChanges());
        }
        it = this.deployablePanels.iterator();
        while (it.hasNext()) {
            pan = (DeployablesPanel)it.next();
            toReturn.addAll(((DeployablesPanel)pan).getChanges());
        }
        it = this.installerPanels.iterator();
        while (it.hasNext()) {
            pan = (InstallersPanel)it.next();
            toReturn.addAll(((InstallersPanel)pan).getChanges());
        }
        return toReturn;
    }

    public String getValidityMessage() {
        return "";
    }

    public boolean isInValidState() {
        return true;
    }

    public void setResolveValues(boolean resolveValues) {
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.validityObserver = observer;
    }

    private void updateContainerPanels() {
        Iterator its = this.containers.iterator();
        while (its.hasNext()) {
            String id = (String)its.next();
            SingleContainerPanel panel = (SingleContainerPanel)this.containerTabs.get(id);
            if (panel == null) {
                panel = new SingleContainerPanel(this.project, id, this.plugin, this.containers, this.installers, this.deployables);
                this.containerTabs.put(id, panel);
            }
            this.tabMain.add(id, panel);
        }
    }

    private void populateDeployables() {
        Iterator it = this.deployables.iterator();
        while (it.hasNext()) {
            String deployable = (String)it.next();
            this.createDeployablePanel(deployable);
        }
    }

    private void populateInstallers() {
        Iterator it = this.installers.iterator();
        while (it.hasNext()) {
            String inst = (String)it.next();
            this.createInstallersPanel(inst);
        }
    }

    private void createDeployablePanel(String id) {
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = this.deployableLayoutIndex++;
        con.anchor = 18;
        con.weightx = 0.1;
        con.weighty = 0.1;
        con.fill = 2;
        con.insets = new Insets(12, 6, 6, 12);
        DeployablesPanel pnl = new DeployablesPanel(this.project, id, this.deployables);
        this.pnlInnerDepl.add((Component)pnl, con);
        this.deployablePanels.add(pnl);
    }

    private void createInstallersPanel(String id) {
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = this.installerLayoutIndex++;
        con.anchor = 18;
        con.weightx = 0.1;
        con.weighty = 0.1;
        con.fill = 2;
        con.insets = new Insets(12, 6, 6, 12);
        InstallersPanel pnl = new InstallersPanel(this.project, id, this.installers);
        this.pnlInnerDepl1.add((Component)pnl, con);
        this.installerPanels.add(pnl);
    }

    private void initComponents() {
        this.tabMain = new JTabbedPane();
        this.pnlBasic = new JPanel();
        this.lblContainers = new JLabel();
        this.txtContainers = new JTextField();
        this.ocContainers = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnContainers = (JButton)this.ocContainers.getComponent();
        this.jPanel3 = new JPanel();
        this.lblProxyHost = new JLabel();
        this.txtProxyHost = new JTextField();
        this.ocProxyHost = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnProxyHost = (JButton)this.ocProxyHost.getComponent();
        this.lblProxyPort = new JLabel();
        this.txtProxyPort = new JTextField();
        this.ocProxyPort = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnProxyPort = (JButton)this.ocProxyPort.getComponent();
        this.lblProxyUser = new JLabel();
        this.txtProxyUser = new JTextField();
        this.ocProxyUser = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnProxyUser = (JButton)this.ocProxyUser.getComponent();
        this.lblProxyPasswd = new JLabel();
        this.txtProxyPasswd = new JTextField();
        this.ocProxyPasswd = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnProxyPasswd = (JButton)this.ocProxyPasswd.getComponent();
        this.lblProxyExcludes = new JLabel();
        this.txtProxyExcludes = new JTextField();
        this.ocProxyExcludes = LocationComboFactory.createPropertiesChange((MavenProject)this.project);
        this.btnProxyExcludes = (JButton)this.ocProxyExcludes.getComponent();
        this.jLabel1 = new JLabel();
        this.pnlDeployables = new JPanel();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.pnlInnerDepl = new JPanel();
        this.pnlInstallers = new JPanel();
        this.jButton2 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.pnlInnerDepl1 = new JPanel();
        this.setLayout(new BorderLayout());
        this.pnlBasic.setLayout(new GridBagLayout());
        this.lblContainers.setText("Defined Containers :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.pnlBasic.add((Component)this.lblContainers, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.pnlBasic.add((Component)this.txtContainers, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.pnlBasic.add((Component)this.btnContainers, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Proxy Settings"));
        this.lblProxyHost.setText("Proxy Host :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel3.add((Component)this.lblProxyHost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel3.add((Component)this.txtProxyHost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel3.add((Component)this.btnProxyHost, gridBagConstraints);
        this.lblProxyPort.setText("Proxy Port :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel3.add((Component)this.lblProxyPort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel3.add((Component)this.txtProxyPort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel3.add((Component)this.btnProxyPort, gridBagConstraints);
        this.lblProxyUser.setText("Proxy User :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel3.add((Component)this.lblProxyUser, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel3.add((Component)this.txtProxyUser, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel3.add((Component)this.btnProxyUser, gridBagConstraints);
        this.lblProxyPasswd.setText("Proxy Password :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel3.add((Component)this.lblProxyPasswd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel3.add((Component)this.txtProxyPasswd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel3.add((Component)this.btnProxyPasswd, gridBagConstraints);
        this.lblProxyExcludes.setText("Exclude hosts :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel3.add((Component)this.lblProxyExcludes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel3.add((Component)this.txtProxyExcludes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel3.add((Component)this.btnProxyExcludes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.pnlBasic.add((Component)this.jPanel3, gridBagConstraints);
        this.jLabel1.setText("<html>A comma separated list of container instance names that you define for this project and that you want cargo to deploy at. <p>Each container instance gets a separate customization tab.</html>");
        this.jLabel1.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 6, 18, 6);
        this.pnlBasic.add((Component)this.jLabel1, gridBagConstraints);
        this.tabMain.addTab("General", this.pnlBasic);
        this.pnlDeployables.setLayout(new GridBagLayout());
        this.jButton1.setText("Add Deployable");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIPanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(12, 6, 0, 12);
        this.pnlDeployables.add((Component)this.jButton1, gridBagConstraints);
        this.pnlInnerDepl.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.pnlInnerDepl);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.pnlDeployables.add((Component)this.jScrollPane1, gridBagConstraints);
        this.tabMain.addTab("Deployables", this.pnlDeployables);
        this.pnlInstallers.setLayout(new GridBagLayout());
        this.jButton2.setText("Add Installer");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UIPanel.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(12, 6, 0, 12);
        this.pnlInstallers.add((Component)this.jButton2, gridBagConstraints);
        this.pnlInnerDepl1.setLayout(new GridBagLayout());
        this.jScrollPane2.setViewportView(this.pnlInnerDepl1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.pnlInstallers.add((Component)this.jScrollPane2, gridBagConstraints);
        this.tabMain.addTab("Installers", this.pnlInstallers);
        this.add((Component)this.tabMain, "Center");
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        NotifyDescriptor.InputLine nd = new NotifyDescriptor.InputLine("Zip Installer ID:", "Enter Zip Installer ID");
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (ret == NotifyDescriptor.OK_OPTION) {
            this.createInstallersPanel(nd.getInputText());
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        NotifyDescriptor.InputLine nd = new NotifyDescriptor.InputLine("Deployable ID:", "Enter Deployable ID");
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (ret == NotifyDescriptor.OK_OPTION) {
            this.createDeployablePanel(nd.getInputText());
        }
    }
}

