package cat.inspiracio.orange;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cat.inspiracio.servlet.jsp.ServletPageContext;
import cat.inspiracio.util.Timber;

/** For requests to orange templates. */
public class OrangeServlet extends HttpServlet{
	private static final long serialVersionUID = -1871765722924200945L;

	@Override protected void doGet(HttpServletRequest request, HttpServletResponse response)throws ServletException, IOException {
		try{
			response.setContentType("text/html; charset=utf-8");
			
			Template t=template(request, response);	
			t.write();//Exception, may be anything from the Java-islands
			
			String timber=Timber.string();
			if(0<timber.length())
				response.getWriter().append("<!-- ").append(timber).append(" -->");
		}
		
		catch(ClassNotFoundException e){
			error(request, 404, e);
			response.sendError(404);
		}
		
		catch(Exception e){
			error(request, 500, e);
			response.sendError(500);
		}
		
	}

	// helpers ---------------------------------------------------------
	
	private Template template(HttpServletRequest request, HttpServletResponse response) throws ClassNotFoundException, InstantiationException, IllegalAccessException{
	
		//Get reflection out of request time: can we cache this?
		String fqcn=fully(request);
		@SuppressWarnings("unchecked")
		Class<Template>c=(Class<Template>)Class.forName(fqcn);
		
		Template t=c.newInstance();
		
		ServletPageContext pc=new ServletPageContext(this, request, response);
		t.setPageContext(pc);
		return t;
	}
	
	/** An exception has occurred. Puts some attributes into the request. */
	private void error(HttpServletRequest request, int status, Exception e){
		//I think this is incomplete.
		//Where is the spec for these?
		request.setAttribute("request_uri", request.getRequestURI()); 
		request.setAttribute("status_code", status);
		request.setAttribute("servlet_name", getServletName()); 
		request.setAttribute("message", e.getMessage());
		request.setAttribute("stack", e.getStackTrace());

		request.setAttribute("exception", e);
		log("error", e);//primitive logging
	}
	
	/** Makes full java class name from request path.
	 * Example: GET /index.html --> cat.inspiracio.orange.index,java */
	private String fully(HttpServletRequest request){
		String uri=request.getRequestURI();// like /index.html
		String p=packageName(uri);
		String c=className(uri);
		return p + "." + c;
	}
	
	/** Makes a java package name from a request path.
	 *  Package-visibility for tests.
	 
/index.html					--> cat.inspiracio.orange.webapp
/cacti/Cactaceae/6.html		--> cat.inspiracio.orange.webapp.cacti.cactaceae
/WEB-INF/cactus/index.html	--> cat.inspiracio.orange.webapp.web_inf.cactus
/WEB-INF/404.html			--> cat.inspiracio.orange.webapp.web_inf
/WEB-INF/throwable.html		--> cat.inspiracio.orange.webapp.web_inf
/googlef5cc28e2ffb847a5.html--> cat.inspiracio.orange.webapp

	 * @param path like "/WEB-INF/404.html"
	 */
	String packageName(String path){
		
		if(!path.endsWith(".html"))
			throw new RuntimeException("packageName " + path);
		
		//drop file
		int i=path.lastIndexOf("/");
		if(i<0)
			throw new RuntimeException("packageName " + path);
		path=path.substring(0, i);
		
		//separators, clean hyphens, lowercase
		char[] cs=path.replaceAll("/", ".").replaceAll("-", "_").toCharArray();
		for(i=0; i<cs.length; i++)
			cs[i]=Character.toLowerCase(cs[i]);
		
		//common prefix
		return "cat.inspiracio.orange.webapp" + new String(cs);
	}

	/** Make a java class name from request path.
	 * Package-visible for tests.
	 
/index.html					--> index
/cacti/Cactaceae/6.html		--> _6
/WEB-INF/cactus/index.html	--> index
/WEB-INF/404.html			--> _404
/WEB-INF/throwable.html		--> throwable
/googlef5cc28e2ffb847a5.html--> googlef5cc28e2ffb847a5

	 * @param path like "/cacti/Cactaceae/6.html"
	 * @return Just the class name without package, like "_6"
	 */
	String className(String path){
		
		int i=path.lastIndexOf("/");
		if(i<0)
			throw new RuntimeException("className " + path);
		
		path=path.substring(i+1);//drop folders
		path=path.substring(0, path.length()-5);//drop .html
		
		//First character legal
		if(!Character.isJavaIdentifierStart(path.charAt(0)))
			path="_" + path;
		
		//clean hyphens
		char[] cs=path.replaceAll("-", "_").toCharArray();
		
		//XXX There may still be illegal characters.
		
		return new String(cs);
	}
	
}

