/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.orange;

import cat.inspiracio.orange.Template;
import cat.inspiracio.servlet.jsp.ServletPageContext;
import cat.inspiracio.util.Timber;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

public class OrangeServlet
extends HttpServlet {
    private static final long serialVersionUID = -1871765722924200945L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            response.setContentType("text/html; charset=utf-8");
            Template t = this.template(request, response);
            t.write();
            String timber = Timber.string();
            if (0 < timber.length()) {
                response.getWriter().append("<!-- ").append(timber).append(" -->");
            }
        }
        catch (ClassNotFoundException e) {
            this.error(request, 404, e);
            response.sendError(404);
        }
        catch (Exception e) {
            this.error(request, 500, e);
            response.sendError(500);
        }
    }

    private Template template(HttpServletRequest request, HttpServletResponse response) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String fqcn = this.fully(request);
        Class<?> c = Class.forName(fqcn);
        Template t = (Template)c.newInstance();
        ServletPageContext pc = new ServletPageContext((HttpServlet)this, request, response);
        t.setPageContext((PageContext)pc);
        return t;
    }

    private void error(HttpServletRequest request, int status, Exception e) {
        request.setAttribute("request_uri", (Object)request.getRequestURI());
        request.setAttribute("status_code", (Object)status);
        request.setAttribute("servlet_name", (Object)this.getServletName());
        request.setAttribute("message", (Object)e.getMessage());
        request.setAttribute("stack", (Object)e.getStackTrace());
        request.setAttribute("exception", (Object)e);
        this.log("error", e);
    }

    private String fully(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String p = this.packageName(uri);
        String c = this.className(uri);
        return p + "." + c;
    }

    String packageName(String path) {
        if (!path.endsWith(".html")) {
            throw new RuntimeException("packageName " + path);
        }
        int i = path.lastIndexOf("/");
        if (i < 0) {
            throw new RuntimeException("packageName " + path);
        }
        path = path.substring(0, i);
        char[] cs = path.replaceAll("/", ".").replaceAll("-", "_").toCharArray();
        for (i = 0; i < cs.length; ++i) {
            cs[i] = Character.toLowerCase(cs[i]);
        }
        return "cat.inspiracio.orange.webapp" + new String(cs);
    }

    String className(String path) {
        int i = path.lastIndexOf("/");
        if (i < 0) {
            throw new RuntimeException("className " + path);
        }
        path = path.substring(i + 1);
        if (!Character.isJavaIdentifierStart((path = path.substring(0, path.length() - 5)).charAt(0))) {
            path = "_" + path;
        }
        char[] cs = path.replaceAll("-", "_").toCharArray();
        return new String(cs);
    }
}

