/*
 * Decompiled with CFR 0.152.
 */
package cat.inspiracio.orange;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public abstract class Template {
    private static final String NL = "\n";
    protected JspWriter out;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected HttpSession session;
    protected PageContext pageContext;
    protected ServletContext application;
    protected ServletConfig config;
    protected Template page;
    protected Throwable exception;

    public final void setPageContext(PageContext pc) {
        this.out = pc.getOut();
        this.pageContext = pc;
        this.request = (HttpServletRequest)pc.getRequest();
        this.response = (HttpServletResponse)pc.getResponse();
        this.session = pc.getSession();
        this.application = pc.getServletContext();
        this.config = pc.getServletConfig();
        this.page = this;
        this.exception = pc.getException();
    }

    public abstract void write() throws Exception;

    protected final void substitute(String v) throws Exception {
        String n = this.resolve(v);
        Class<?> c = Class.forName(n);
        Template t = (Template)c.newInstance();
        t.setPageContext(this.pageContext);
        t.write();
    }

    String getClassName() {
        return this.getClass().getName();
    }

    final String resolve(String v) {
        int j;
        int i;
        String n = "cat.inspiracio.orange.webapp.hr";
        if (v.startsWith("/")) {
            v = v.substring(1);
            v = v.substring(0, v.length() - 5);
            v = v.replace('-', '_');
            v = v.replace('/', '.');
            n = "cat.inspiracio.orange.webapp." + v;
            return n;
        }
        String current = this.getClassName();
        String[] parts = current.split("\\.");
        v = v.substring(0, v.length() - 5);
        v = v.replace('-', '_');
        String[] vs = v.split("/");
        String[] cs = new String[parts.length - 1 + vs.length];
        for (i = 0; i < parts.length - 1; ++i) {
            cs[i] = parts[i];
        }
        i = parts.length - 1;
        for (j = 0; j < vs.length; ++j) {
            String s = vs[j];
            if (".".equals(s)) continue;
            if ("..".equals(s)) {
                --i;
                continue;
            }
            cs[i++] = s;
        }
        n = "";
        for (j = 0; j < i; ++j) {
            n = n + "." + cs[j];
        }
        n = n.substring(1);
        return n;
    }

    protected final String quote(Object o) {
        return this.quote(o.toString());
    }

    protected final String quote(String value) {
        if (this.contains(value, '\"')) {
            value = value.replaceAll("\"", "&quot;");
        }
        return '\"' + value + '\"';
    }

    protected final String escape(Object o) {
        return this.escape(o.toString());
    }

    protected final String escape(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("&", "&amp;").replace("<", "&lt;");
    }

    protected final String escape(int i) {
        return Integer.toString(i);
    }

    protected final void attribute(String key, boolean b) throws IOException {
        if (b) {
            this.write(" " + key);
        }
    }

    protected final void attribute(String key, Object v) throws IOException {
        if (v == null) {
            this.write(" " + key);
            return;
        }
        String s = v.toString();
        if (this.empty(s)) {
            this.write(" " + key);
            return;
        }
        this.write(" " + key + "=" + this.quote(s));
    }

    private final boolean empty(String s) {
        return s == null || 0 == s.length();
    }

    private final boolean contains(String value, char c) {
        return 0 <= value.indexOf(c);
    }

    public final Template write(int i) throws IOException {
        this.out.write(Integer.toString(i));
        return this;
    }

    public final Template write(Object o) throws IOException {
        if (o == null) {
            return this;
        }
        String s = o.toString();
        return this.write(s);
    }

    public final Template write(String s) throws IOException {
        if (!this.empty(s)) {
            this.out.write(s);
        }
        return this;
    }

    public final Template writeln() throws IOException {
        return this.write(NL);
    }

    public final Template writeln(String s) throws IOException {
        this.write(s);
        return this.writeln();
    }
}

