/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.stp;

import cn.dev33.satoken.SaTokenManager;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.dao.SaTokenDao;

public class SaLoginModel {
    public String device;
    public Boolean isLastingCookie;
    public Long timeout;

    public String getDevice() {
        return this.device;
    }

    public SaLoginModel setDevice(String device) {
        this.device = device;
        return this;
    }

    public Boolean getIsLastingCookie() {
        return this.isLastingCookie;
    }

    public SaLoginModel setIsLastingCookie(Boolean isLastingCookie) {
        this.isLastingCookie = isLastingCookie;
        return this;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public SaLoginModel setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public int getCookieTimeout() {
        if (!this.isLastingCookie.booleanValue()) {
            return -1;
        }
        if (this.timeout == SaTokenDao.NEVER_EXPIRE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.timeout.longValue();
    }

    public SaLoginModel build() {
        return this.build(SaTokenManager.getConfig());
    }

    public SaLoginModel build(SaTokenConfig config) {
        if (this.device == null) {
            this.device = "default-device";
        }
        if (this.isLastingCookie == null) {
            this.isLastingCookie = true;
        }
        if (this.timeout == null) {
            this.timeout = config.getTimeout();
        }
        return this;
    }

    public static SaLoginModel create() {
        return new SaLoginModel();
    }

    public String toString() {
        return "SaLoginModel [device=" + this.device + ", isLastingCookie=" + this.isLastingCookie + ", timeout=" + this.timeout + "]";
    }
}

